/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud;

import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.CrudClient;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.CrudException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.RequestBuilder;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.Resource;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.ResponseParser;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.ServiceException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.GenericHttpRequest;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.GenericHttpResponse;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.HttpService;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.HttpServiceException;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractCrudClient<T extends Enum<T>, U extends Resource<?>>
implements CrudClient<T, U> {
    protected final RequestBuilder<T, U> requestBuilder;
    protected final HttpService httpService;
    protected final ResponseParser<U> responseParser;

    public AbstractCrudClient(RequestBuilder<T, U> requestBuilder, HttpService httpService, ResponseParser<U> responseParser) {
        this.requestBuilder = requestBuilder;
        this.httpService = httpService;
        this.responseParser = responseParser;
    }

    @Override
    public U create(Map<T, String> creds, U resource) throws CrudException {
        GenericHttpRequest req = this.requestBuilder.buildCreateRequest(creds, resource);
        GenericHttpResponse resp = null;
        try {
            resp = this.httpService.execute(req);
        }
        catch (HttpServiceException e) {
            throw new ServiceException(e);
        }
        U createdResource = this.responseParser.parseCreateResponse(resp);
        return createdResource;
    }

    @Override
    public U read(Map<T, String> creds, U resource) throws CrudException {
        GenericHttpRequest req = this.requestBuilder.buildReadRequest(creds, resource);
        GenericHttpResponse resp = null;
        try {
            resp = this.httpService.execute(req);
        }
        catch (HttpServiceException e) {
            throw new ServiceException(e);
        }
        U readResource = this.responseParser.parseReadResponse(resp);
        return readResource;
    }

    @Override
    public U update(Map<T, String> creds, U resource) throws CrudException {
        GenericHttpRequest req = this.requestBuilder.buildUpdateRequest(creds, resource);
        GenericHttpResponse resp = null;
        try {
            resp = this.httpService.execute(req);
        }
        catch (HttpServiceException e) {
            throw new ServiceException(e);
        }
        U updatedResource = this.responseParser.parseUpdateResponse(resp);
        return updatedResource;
    }

    @Override
    public Optional<U> partialUpdate(Map<T, String> creds, U resource) throws CrudException {
        U existingResource = this.read(creds, resource);
        Optional<GenericHttpRequest> req = this.requestBuilder.buildPartialUpdateRequest(creds, existingResource, resource);
        if (!req.isPresent()) {
            return Optional.empty();
        }
        GenericHttpResponse resp = null;
        try {
            resp = this.httpService.execute(req.get());
        }
        catch (HttpServiceException e) {
            throw new ServiceException(e);
        }
        return this.responseParser.parsePartialUpdateResponse(resp);
    }

    @Override
    public void delete(Map<T, String> creds, U resource) throws CrudException {
        GenericHttpRequest req = this.requestBuilder.buildDeleteRequest(creds, resource);
        GenericHttpResponse resp = null;
        try {
            resp = this.httpService.execute(req);
        }
        catch (HttpServiceException e) {
            throw new ServiceException(e);
        }
        this.responseParser.parseDeleteResponse(resp);
    }

    @Override
    public List<U> search(Map<T, String> creds, U resource) throws CrudException {
        GenericHttpRequest req = this.requestBuilder.buildSearchRequest(creds, resource);
        GenericHttpResponse resp = null;
        try {
            resp = this.httpService.execute(req);
        }
        catch (HttpServiceException e) {
            throw new ServiceException(e);
        }
        List<U> searchedResources = this.responseParser.parseSearchResponse(resp);
        return searchedResources;
    }
}

