/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone;

import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.commons.lang3.StringUtils;
import java.util.Map;

public enum ClientConfig {
    API_BASE_URL,
    ENV_ID,
    ACCESS_TOKEN,
    P1_DIRECTORY_BASE_URL,
    P1_MFA_DEVICE_BASE_URL,
    P1_IDENTITY_PROVIDER_BASE_URL;

    public static final String DEFAULT_API_BASE_URL = "https://api.pingone.com/v1";

    public static String getDirectoryBaseUrl(Map<ClientConfig, String> config) {
        return ClientConfig.getApiBaseUrl(config, P1_DIRECTORY_BASE_URL);
    }

    public static String getMfaDeviceBaseUrl(Map<ClientConfig, String> config) {
        return ClientConfig.getApiBaseUrl(config, P1_MFA_DEVICE_BASE_URL);
    }

    public static String getIdentityProviderBaseUrl(Map<ClientConfig, String> config) {
        return ClientConfig.getApiBaseUrl(config, P1_IDENTITY_PROVIDER_BASE_URL);
    }

    private static String getApiBaseUrl(Map<ClientConfig, String> config, ClientConfig apiBaseUrlKey) {
        if (config == null || config.isEmpty()) {
            return DEFAULT_API_BASE_URL;
        }
        if (StringUtils.isNotBlank(config.get((Object)apiBaseUrlKey))) {
            return config.get((Object)apiBaseUrlKey);
        }
        if (StringUtils.isNotBlank(config.get((Object)API_BASE_URL))) {
            return config.get((Object)API_BASE_URL);
        }
        return DEFAULT_API_BASE_URL;
    }

    public static String getEnvId(Map<ClientConfig, String> config) {
        return config.get((Object)ENV_ID);
    }

    public static String getAccessToken(Map<ClientConfig, String> config) {
        return config.get((Object)ACCESS_TOKEN);
    }
}

