/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.device.crud;

import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.RequestBuilder;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.ResourceException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.GenericHttpBody;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.GenericHttpHeaders;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.GenericHttpMethod;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.GenericHttpQueryParams;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.GenericHttpRequest;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.ClientConfig;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.device.Device;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.device.DeviceAttribute;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.device.DeviceType;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.device.crud.DeviceTransformer;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.device.crud.Translator;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.device.crud.dto.DeviceDto;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.device.crud.dto.DeviceUpdateNicknameReqDto;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;

public class DeviceRequestBuilder
implements RequestBuilder<ClientConfig, Device> {
    private static final String DEVICE_URL = "%s/environments/%s/users/%s/devices";
    private static final String DEVICE_BY_ID_URL = "%s/environments/%s/users/%s/devices/%s";
    private static final String DEVICE_UPDATE_NICKNAME_URL = "%s/environments/%s/users/%s/devices/%s/nickname";
    private static final String STATUS_FILTER = "status eq \"%s\"";
    private static final String TYPE_FILTER = "type eq \"%s\"";
    private static final String MISSING_CONFIG_ATTR_ERR_MSG = "Error creating request: Missing required connection configuration attribute.";
    private static final String MISSING_DEVICE_ATTR_ERR_MSG = "Error creating request: Missing required device attribute.";
    private ObjectMapper mapper;
    private Translator<Device, DeviceDto> translator;

    public DeviceRequestBuilder() {
        this(new ObjectMapper(), new DeviceTransformer());
    }

    public DeviceRequestBuilder(ObjectMapper mapper, Translator<Device, DeviceDto> translator) {
        this.mapper = mapper;
        this.translator = translator;
    }

    @Override
    public GenericHttpRequest buildCreateRequest(Map<ClientConfig, String> connectionConfig, Device device) throws UnsupportedOperationException, ResourceException {
        String userId = device.getOne(DeviceAttribute.USER_ID);
        String p14cUrl = ClientConfig.getMfaDeviceBaseUrl(connectionConfig);
        String environmentId = ClientConfig.getEnvId(connectionConfig);
        DeviceDto resource = this.translator.translate(device);
        if (environmentId == null) {
            throw new ResourceException(MISSING_CONFIG_ATTR_ERR_MSG);
        }
        if (userId == null || resource.getType() == null) {
            throw new ResourceException(MISSING_DEVICE_ATTR_ERR_MSG);
        }
        if (resource.getType().equals(DeviceType.MOBILE.getType())) {
            throw new UnsupportedOperationException(String.format("Create device request for device type of \"%s\" is not supported.", DeviceType.MOBILE.getType()));
        }
        String url = String.format(DEVICE_URL, p14cUrl, environmentId, userId);
        GenericHttpHeaders headers = this.buildHeaders(connectionConfig);
        String serializedDevice = null;
        try {
            serializedDevice = this.mapper.writeValueAsString(resource);
        }
        catch (JsonProcessingException e) {
            throw new ResourceException("Unable to build create device request.", e);
        }
        GenericHttpBody body = new GenericHttpBody(serializedDevice, "application/json", "UTF-8");
        GenericHttpRequest req = new GenericHttpRequest(GenericHttpMethod.POST, url, new GenericHttpQueryParams(), headers, body);
        return req;
    }

    @Override
    public GenericHttpRequest buildReadRequest(Map<ClientConfig, String> connectionConfig, Device device) throws ResourceException {
        String userId = device.getOne(DeviceAttribute.USER_ID);
        String deviceId = device.getId();
        String p14cUrl = ClientConfig.getMfaDeviceBaseUrl(connectionConfig);
        String environmentId = ClientConfig.getEnvId(connectionConfig);
        if (environmentId == null) {
            throw new ResourceException(MISSING_CONFIG_ATTR_ERR_MSG);
        }
        if (userId == null || deviceId == null) {
            throw new ResourceException(MISSING_DEVICE_ATTR_ERR_MSG);
        }
        String url = String.format(DEVICE_BY_ID_URL, p14cUrl, environmentId, userId, deviceId);
        GenericHttpHeaders headers = this.buildHeaders(connectionConfig);
        GenericHttpRequest req = new GenericHttpRequest(GenericHttpMethod.GET, url, headers);
        return req;
    }

    @Override
    public Optional<GenericHttpRequest> buildPartialUpdateRequest(Map<ClientConfig, String> connectionConfig, Device oldDevice, Device newDevice) throws ResourceException {
        String userId = newDevice.getOne(DeviceAttribute.USER_ID);
        if (userId == null) {
            throw new ResourceException(MISSING_DEVICE_ATTR_ERR_MSG);
        }
        String deviceId = newDevice.getId();
        if (deviceId == null) {
            throw new ResourceException(MISSING_DEVICE_ATTR_ERR_MSG);
        }
        String environmentId = ClientConfig.getEnvId(connectionConfig);
        if (environmentId == null) {
            throw new ResourceException(MISSING_CONFIG_ATTR_ERR_MSG);
        }
        String updatedDeviceNickname = newDevice.getOne(DeviceAttribute.NICKNAME);
        updatedDeviceNickname = updatedDeviceNickname != null ? updatedDeviceNickname : "";
        DeviceUpdateNicknameReqDto deviceNicknameDto = new DeviceUpdateNicknameReqDto(updatedDeviceNickname);
        String p14cUrl = ClientConfig.getMfaDeviceBaseUrl(connectionConfig);
        String url = String.format(DEVICE_UPDATE_NICKNAME_URL, p14cUrl, environmentId, userId, deviceId);
        GenericHttpHeaders headers = this.buildHeaders(connectionConfig);
        String serializedDevice = null;
        try {
            serializedDevice = this.mapper.writeValueAsString(deviceNicknameDto);
        }
        catch (JsonProcessingException e) {
            throw new ResourceException("Unable to build update device request.", e);
        }
        GenericHttpBody body = new GenericHttpBody(serializedDevice, "application/json", "UTF-8");
        GenericHttpRequest req = new GenericHttpRequest(GenericHttpMethod.PUT, url, new GenericHttpQueryParams(), headers, body);
        return Optional.of(req);
    }

    @Override
    public GenericHttpRequest buildUpdateRequest(Map<ClientConfig, String> connectionConfig, Device device) {
        throw new UnsupportedOperationException("Device update request is not supported.");
    }

    @Override
    public GenericHttpRequest buildDeleteRequest(Map<ClientConfig, String> connectionConfig, Device device) throws ResourceException {
        String userId = device.getOne(DeviceAttribute.USER_ID);
        String deviceId = device.getId();
        String p14cUrl = ClientConfig.getMfaDeviceBaseUrl(connectionConfig);
        String environmentId = ClientConfig.getEnvId(connectionConfig);
        if (environmentId == null) {
            throw new ResourceException(MISSING_CONFIG_ATTR_ERR_MSG);
        }
        if (userId == null || deviceId == null) {
            throw new ResourceException(MISSING_DEVICE_ATTR_ERR_MSG);
        }
        String url = String.format(DEVICE_BY_ID_URL, p14cUrl, environmentId, userId, deviceId);
        GenericHttpHeaders headers = this.buildHeaders(connectionConfig);
        GenericHttpRequest req = new GenericHttpRequest(GenericHttpMethod.DELETE, url, headers);
        return req;
    }

    @Override
    public GenericHttpRequest buildSearchRequest(Map<ClientConfig, String> connectionConfig, Device device) throws ResourceException {
        String userId = device.getOne(DeviceAttribute.USER_ID);
        String p14cUrl = ClientConfig.getMfaDeviceBaseUrl(connectionConfig);
        String environmentId = ClientConfig.getEnvId(connectionConfig);
        if (environmentId == null) {
            throw new ResourceException(MISSING_CONFIG_ATTR_ERR_MSG);
        }
        if (userId == null) {
            throw new ResourceException(MISSING_DEVICE_ATTR_ERR_MSG);
        }
        String url = String.format(DEVICE_URL, p14cUrl, environmentId, userId);
        String status = device.getOne(DeviceAttribute.STATUS);
        String type = device.getOne(DeviceAttribute.TYPE);
        StringJoiner filterQuery = new StringJoiner(" and ");
        GenericHttpQueryParams params = new GenericHttpQueryParams();
        if (status != null) {
            filterQuery.add(String.format(STATUS_FILTER, status));
        }
        if (type != null) {
            filterQuery.add(String.format(TYPE_FILTER, type));
        }
        if (status != null || type != null) {
            params.add("filter", filterQuery.toString());
        }
        GenericHttpHeaders headers = this.buildHeaders(connectionConfig);
        GenericHttpRequest req = new GenericHttpRequest(GenericHttpMethod.GET, url, params, headers);
        return req;
    }

    private GenericHttpHeaders buildHeaders(Map<ClientConfig, String> connectionConfig) throws ResourceException {
        String accessToken = ClientConfig.getAccessToken(connectionConfig);
        if (accessToken == null) {
            throw new ResourceException(MISSING_CONFIG_ATTR_ERR_MSG);
        }
        GenericHttpHeaders headers = new GenericHttpHeaders();
        headers.addHeader("Accept", "application/json");
        headers.addHeader("Content-Type", "application/json");
        headers.addHeader("Authorization", "Bearer " + accessToken);
        return headers;
    }
}

