/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.idp.crud;

import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.CrudException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.ResourceException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.ResponseParser;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.GenericHttpBody;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.GenericHttpResponse;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.idp.IdentityProvider;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.idp.crud.IdpDtoTranslator;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.idp.crud.Translator;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.idp.crud.dto.response.Embedded;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.idp.crud.dto.response.IdpDto;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.idp.crud.dto.response.ListIdpResponse;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.idp.crud.exception.IdpNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class IdpResponseParser
implements ResponseParser<IdentityProvider> {
    private ObjectMapper mapper;
    private Translator<IdpDto, IdentityProvider> translator;

    public IdpResponseParser() {
        this.mapper = new ObjectMapper();
        this.translator = new IdpDtoTranslator();
    }

    public IdpResponseParser(ObjectMapper mapper, Translator<IdpDto, IdentityProvider> translator) {
        this.mapper = mapper;
        this.translator = translator;
    }

    @Override
    public IdentityProvider parseCreateResponse(GenericHttpResponse resp) throws CrudException {
        return (IdentityProvider)ResponseParser.super.parseCreateResponse(resp);
    }

    @Override
    public IdentityProvider parseReadResponse(GenericHttpResponse resp) throws CrudException {
        String body;
        Integer statusCode = resp.getStatusCode();
        GenericHttpBody ghb = resp.getBody();
        String string = body = ghb != null ? ghb.getContent() : null;
        if (statusCode != null && statusCode == 404) {
            throw new IdpNotFoundException(String.format("Identity provider could not be found. Status code was \"%d\". Response was: \"%s\"", statusCode, body));
        }
        if (statusCode != null && statusCode != 200) {
            throw new ResourceException(String.format("The read Identity Provider response indicated an error. Status code was \"%d\". Response was: \"%s\"", statusCode, body));
        }
        IdpDto resource = null;
        try {
            resource = this.mapper.readValue(body, IdpDto.class);
        }
        catch (JsonProcessingException e) {
            throw new ResourceException("Unable to deserialize the read Identity Provider response.", e);
        }
        return this.translator.translate(resource);
    }

    @Override
    public IdentityProvider parseUpdateResponse(GenericHttpResponse resp) throws CrudException {
        return (IdentityProvider)ResponseParser.super.parseUpdateResponse(resp);
    }

    @Override
    public Optional<IdentityProvider> parsePartialUpdateResponse(GenericHttpResponse resp) throws CrudException {
        return ResponseParser.super.parsePartialUpdateResponse(resp);
    }

    @Override
    public void parseDeleteResponse(GenericHttpResponse resp) throws CrudException {
        ResponseParser.super.parseDeleteResponse(resp);
    }

    @Override
    public List<IdentityProvider> parseSearchResponse(GenericHttpResponse resp) throws CrudException {
        String body;
        Integer statusCode = resp.getStatusCode();
        GenericHttpBody ghb = resp.getBody();
        String string = body = ghb != null ? ghb.getContent() : null;
        if (statusCode != null && statusCode != 200) {
            throw new ResourceException(String.format("The read all Identity Providers response indicated an error. Status code was \"%d\". Response was: \"%s\"", statusCode, body));
        }
        ListIdpResponse response = null;
        try {
            response = this.mapper.readValue(body, ListIdpResponse.class);
        }
        catch (JsonProcessingException e) {
            throw new ResourceException("Unable to deserialize the read all Identity Providers response.", e);
        }
        ArrayList<IdentityProvider> idps = new ArrayList<IdentityProvider>();
        Embedded embedded = response.getEmbedded();
        ArrayList listIdps = embedded != null ? embedded.getIdentityProviders() : new ArrayList();
        for (IdpDto idpDto : listIdps) {
            idps.add(this.translator.translate(idpDto));
        }
        return idps;
    }
}

