/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.population.crud;

import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.CrudException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.ResourceException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.ResponseParser;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.GenericHttpBody;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.GenericHttpResponse;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.population.Population;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.population.crud.PopulationDtoTranslator;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.population.crud.Translator;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.population.crud.dto.response.Embedded;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.population.crud.dto.response.ListPopulationResponse;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.population.crud.dto.response.PopulationDto;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.population.crud.exception.PopulationNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class PopulationResponseParser
implements ResponseParser<Population> {
    private ObjectMapper mapper;
    private Translator<PopulationDto, Population> translator;

    public PopulationResponseParser() {
        this.mapper = new ObjectMapper();
        this.translator = new PopulationDtoTranslator();
    }

    public PopulationResponseParser(ObjectMapper mapper, Translator<PopulationDto, Population> translator) {
        this.mapper = mapper;
        this.translator = translator;
    }

    @Override
    public Population parseCreateResponse(GenericHttpResponse resp) throws CrudException {
        return (Population)ResponseParser.super.parseCreateResponse(resp);
    }

    @Override
    public Population parseReadResponse(GenericHttpResponse resp) throws CrudException {
        String body;
        Integer statusCode = resp.getStatusCode();
        GenericHttpBody ghb = resp.getBody();
        String string = body = ghb != null ? ghb.getContent() : null;
        if (statusCode != null && statusCode == 404) {
            throw new PopulationNotFoundException(String.format("Population could not be found. Status code was \"%d\". Response was: \"%s\"", statusCode, body));
        }
        if (statusCode != null && statusCode != 200) {
            throw new ResourceException(String.format("The read Population response indicated an error. Status code was \"%d\". Response was: \"%s\"", statusCode, body));
        }
        PopulationDto resource = null;
        try {
            resource = this.mapper.readValue(body, PopulationDto.class);
        }
        catch (JsonProcessingException e) {
            throw new ResourceException("Unable to deserialize the read Population response.", e);
        }
        return this.translator.translate(resource);
    }

    @Override
    public Population parseUpdateResponse(GenericHttpResponse resp) throws CrudException {
        return (Population)ResponseParser.super.parseUpdateResponse(resp);
    }

    @Override
    public Optional<Population> parsePartialUpdateResponse(GenericHttpResponse resp) throws CrudException {
        return ResponseParser.super.parsePartialUpdateResponse(resp);
    }

    @Override
    public void parseDeleteResponse(GenericHttpResponse resp) throws CrudException {
        ResponseParser.super.parseDeleteResponse(resp);
    }

    @Override
    public List<Population> parseSearchResponse(GenericHttpResponse resp) throws CrudException {
        String body;
        Integer statusCode = resp.getStatusCode();
        GenericHttpBody ghb = resp.getBody();
        String string = body = ghb != null ? ghb.getContent() : null;
        if (statusCode != null && statusCode != 200) {
            throw new ResourceException(String.format("The read all Populations response indicated an error. Status code was \"%d\". Response was: \"%s\"", statusCode, body));
        }
        ListPopulationResponse response = null;
        try {
            response = this.mapper.readValue(body, ListPopulationResponse.class);
        }
        catch (JsonProcessingException e) {
            throw new ResourceException("Unable to deserialize the read all Populations response.", e);
        }
        ArrayList<Population> idps = new ArrayList<Population>();
        Embedded embedded = response.getEmbedded();
        ArrayList listIdps = embedded != null ? embedded.getPopulations() : new ArrayList();
        for (PopulationDto idpDto : listIdps) {
            idps.add(this.translator.translate(idpDto));
        }
        return idps;
    }
}

