/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.crud;

import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.RequestBuilder;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.ResourceException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.ServiceException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.GenericHttpHeaders;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.GenericHttpMethod;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.GenericHttpRequest;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.ClientConfig;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.SchemaAttribute;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.SchemaAttributeProperty;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.crud.exception.ConfigValidationException;
import java.util.Map;
import java.util.Optional;

public class SchemaAttributeRequestBuilder
implements RequestBuilder<ClientConfig, SchemaAttribute> {
    private static final String GET_ALL_SCHEMA_ATTRIBUTES_ENDPOINT = "/environments/%s/schemas/%s/attributes";
    private static final String GET_SCHEMA_ATTRIBUTE_ENDPOINT = "/environments/%s/schemas/%s/attributes/%s";

    @Override
    public GenericHttpRequest buildCreateRequest(Map<ClientConfig, String> connectionConfig, SchemaAttribute resource) throws ResourceException, ServiceException {
        return RequestBuilder.super.buildCreateRequest(connectionConfig, resource);
    }

    @Override
    public GenericHttpRequest buildReadRequest(Map<ClientConfig, String> connectionConfig, SchemaAttribute resource) throws ResourceException, ServiceException {
        String baseUrl = ClientConfig.getDirectoryBaseUrl(connectionConfig);
        String envId = ClientConfig.getEnvId(connectionConfig);
        String accessToken = ClientConfig.getAccessToken(connectionConfig);
        this.validateConfig(baseUrl, envId, accessToken);
        String attributeId = resource.getId();
        String schemaId = resource.getOne(SchemaAttributeProperty.SCHEMA_ID);
        this.validateSchemaAttribute(schemaId, attributeId);
        String url = String.format(baseUrl.concat(GET_SCHEMA_ATTRIBUTE_ENDPOINT), envId, schemaId, attributeId);
        GenericHttpHeaders headers = this.buildHeaders(connectionConfig);
        GenericHttpRequest req = new GenericHttpRequest(GenericHttpMethod.GET, url, headers);
        return req;
    }

    @Override
    public GenericHttpRequest buildUpdateRequest(Map<ClientConfig, String> connectionConfig, SchemaAttribute resource) throws ResourceException, ServiceException {
        return RequestBuilder.super.buildUpdateRequest(connectionConfig, resource);
    }

    @Override
    public Optional<GenericHttpRequest> buildPartialUpdateRequest(Map<ClientConfig, String> connectionConfig, SchemaAttribute oldResource, SchemaAttribute newResource) throws ResourceException, ServiceException {
        return RequestBuilder.super.buildPartialUpdateRequest(connectionConfig, oldResource, newResource);
    }

    @Override
    public GenericHttpRequest buildDeleteRequest(Map<ClientConfig, String> connectionConfig, SchemaAttribute resource) throws ResourceException, ServiceException {
        return RequestBuilder.super.buildDeleteRequest(connectionConfig, resource);
    }

    @Override
    public GenericHttpRequest buildSearchRequest(Map<ClientConfig, String> connectionConfig, SchemaAttribute resource) throws ResourceException, ServiceException {
        String baseUrl = ClientConfig.getDirectoryBaseUrl(connectionConfig);
        String envId = ClientConfig.getEnvId(connectionConfig);
        String accessToken = ClientConfig.getAccessToken(connectionConfig);
        this.validateConfig(baseUrl, envId, accessToken);
        String schemaId = resource.getOne(SchemaAttributeProperty.SCHEMA_ID);
        this.validateSchema(schemaId);
        String url = String.format(baseUrl.concat(GET_ALL_SCHEMA_ATTRIBUTES_ENDPOINT), envId, schemaId);
        GenericHttpHeaders headers = this.buildHeaders(connectionConfig);
        GenericHttpRequest req = new GenericHttpRequest(GenericHttpMethod.GET, url, headers);
        return req;
    }

    private void validateConfig(String baseUrl, String envId, String accessToken) throws ConfigValidationException {
        if (baseUrl == null || baseUrl.trim().isEmpty()) {
            throw new ConfigValidationException("PingOne Base Url is missing or empty.");
        }
        if (envId == null || envId.trim().isEmpty()) {
            throw new ConfigValidationException("Environment ID is missing or empty.");
        }
        if (accessToken == null || accessToken.trim().isEmpty()) {
            throw new ConfigValidationException("Access Token is missing or empty.");
        }
    }

    private void validateSchema(String schemaId) throws ConfigValidationException {
        if (schemaId == null || schemaId.trim().isEmpty()) {
            throw new ConfigValidationException("Schema ID is missing or empty.");
        }
    }

    private void validateSchemaAttribute(String schemaId, String attributeId) throws ConfigValidationException {
        this.validateSchema(schemaId);
        if (attributeId == null || attributeId.trim().isEmpty()) {
            throw new ConfigValidationException("Attribute ID is missing or empty.");
        }
    }

    private GenericHttpHeaders buildHeaders(Map<ClientConfig, String> connectionConfig) throws ResourceException {
        String accessToken = ClientConfig.getAccessToken(connectionConfig);
        GenericHttpHeaders headers = new GenericHttpHeaders();
        headers.addHeader("Accept", "application/json");
        headers.addHeader("Authorization", "Bearer " + accessToken);
        return headers;
    }
}

