/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.crud;

import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.fasterxml.jackson.core.type.TypeReference;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.CrudException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.ResourceException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.ResponseParser;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.GenericHttpBody;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.GenericHttpResponse;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.Schema;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.crud.SchemaDtoTranslator;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.crud.Translator;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.crud.dto.response.ListResponse;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.crud.dto.response.SchemaDto;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.crud.dto.response.SchemaList;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.crud.exception.ResourceNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class SchemaResponseParser
implements ResponseParser<Schema> {
    protected static final TypeReference<ListResponse<SchemaList>> SCHEMA_LIST_TYPE_REF = new TypeReference<ListResponse<SchemaList>>(){};
    private ObjectMapper mapper;
    private Translator<SchemaDto, Schema> translator;

    public SchemaResponseParser() {
        this.mapper = new ObjectMapper();
        this.translator = new SchemaDtoTranslator();
    }

    public SchemaResponseParser(ObjectMapper mapper, Translator<SchemaDto, Schema> translator) {
        this.mapper = mapper;
        this.translator = translator;
    }

    @Override
    public Schema parseCreateResponse(GenericHttpResponse resp) throws CrudException {
        return (Schema)ResponseParser.super.parseCreateResponse(resp);
    }

    @Override
    public Schema parseReadResponse(GenericHttpResponse resp) throws CrudException {
        String body;
        Integer statusCode = resp.getStatusCode();
        GenericHttpBody ghb = resp.getBody();
        String string = body = ghb != null ? ghb.getContent() : null;
        if (statusCode != null && statusCode == 404) {
            throw new ResourceNotFoundException(String.format("Schema could not be found. Status code was \"%d\". Response was: \"%s\"", statusCode, body));
        }
        if (statusCode != null && statusCode != 200) {
            throw new ResourceException(String.format("The read Schema response indicated an error. Status code was \"%d\". Response was: \"%s\"", statusCode, body));
        }
        SchemaDto resource = null;
        try {
            resource = this.mapper.readValue(body, SchemaDto.class);
        }
        catch (JsonProcessingException e) {
            throw new ResourceException("Unable to deserialize the read Schema response.", e);
        }
        return this.translator.translate(resource);
    }

    @Override
    public Schema parseUpdateResponse(GenericHttpResponse resp) throws CrudException {
        return (Schema)ResponseParser.super.parseUpdateResponse(resp);
    }

    @Override
    public Optional<Schema> parsePartialUpdateResponse(GenericHttpResponse resp) throws CrudException {
        return ResponseParser.super.parsePartialUpdateResponse(resp);
    }

    @Override
    public void parseDeleteResponse(GenericHttpResponse resp) throws CrudException {
        ResponseParser.super.parseDeleteResponse(resp);
    }

    @Override
    public List<Schema> parseSearchResponse(GenericHttpResponse resp) throws CrudException {
        String body;
        Integer statusCode = resp.getStatusCode();
        GenericHttpBody ghb = resp.getBody();
        String string = body = ghb != null ? ghb.getContent() : null;
        if (statusCode != null && statusCode != 200) {
            throw new ResourceException(String.format("The read all Schemas response indicated an error. Status code was \"%d\". Response was: \"%s\"", statusCode, body));
        }
        ListResponse<SchemaList> response = null;
        try {
            response = this.mapper.readValue(body, SCHEMA_LIST_TYPE_REF);
        }
        catch (JsonProcessingException e) {
            throw new ResourceException("Unable to deserialize the read all Schemas response.", e);
        }
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        SchemaList embedded = response.getEmbedded();
        ArrayList schemaList = embedded != null ? embedded.getSchemas() : new ArrayList();
        for (SchemaDto schemaDto : schemaList) {
            schemas.add(this.translator.translate(schemaDto));
        }
        return schemas;
    }
}

