/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.unboundid.scim2.common.types;

import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.unboundid.scim2.common.BaseScimResource;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.unboundid.scim2.common.annotations.Attribute;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.unboundid.scim2.common.annotations.Schema;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.unboundid.scim2.common.types.AttributeDefinition;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

@Schema(id="urn:ietf:params:scim:schemas:core:2.0:ResourceType", name="Resource Type", description="SCIM 2.0 Resource Type Resource")
public class ResourceTypeResource
extends BaseScimResource {
    @Attribute(description="The resource type name.", isRequired=true, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_ONLY, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private final String name;
    @Attribute(description="The resource type's human readable description.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_ONLY, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private final String description;
    @Attribute(description="The resource type's HTTP addressable endpoint relative to the Base URL; e.g., \"/Users\".", referenceTypes={"uri"}, isRequired=true, isCaseExact=true, mutability=AttributeDefinition.Mutability.READ_ONLY, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private final URI endpoint;
    @Attribute(description="The resource types primary/base schema URI.", referenceTypes={"uri"}, isRequired=true, isCaseExact=true, mutability=AttributeDefinition.Mutability.READ_ONLY, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private final URI schema;
    @Attribute(description="A list of URIs of the resource type's schema extensions.", isRequired=false, mutability=AttributeDefinition.Mutability.READ_ONLY, returned=AttributeDefinition.Returned.DEFAULT, multiValueClass=SchemaExtension.class)
    private final Collection<SchemaExtension> schemaExtensions;

    public ResourceTypeResource(String name, String description, URI endpoint, URI schema) {
        this(name, name, description, endpoint, schema, null);
    }

    @JsonCreator
    public ResourceTypeResource(@JsonProperty(value="id") String id, @JsonProperty(value="name", required=true) String name, @JsonProperty(value="description") String description, @JsonProperty(value="endpoint", required=true) URI endpoint, @JsonProperty(value="schema", required=true) URI schema, @JsonProperty(value="schemaExtensions") Collection<SchemaExtension> schemaExtensions) {
        super(id);
        this.name = name;
        this.description = description;
        this.endpoint = endpoint;
        this.schema = schema;
        this.schemaExtensions = schemaExtensions == null ? null : Collections.unmodifiableList(new ArrayList<SchemaExtension>(schemaExtensions));
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public URI getSchema() {
        return this.schema;
    }

    public Collection<SchemaExtension> getSchemaExtensions() {
        return this.schemaExtensions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceTypeResource that = (ResourceTypeResource)o;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.endpoint != null ? !this.endpoint.equals(that.endpoint) : that.endpoint != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.schema != null ? !this.schema.equals(that.schema) : that.schema != null) {
            return false;
        }
        return !(this.schemaExtensions != null ? !this.schemaExtensions.equals(that.schemaExtensions) : that.schemaExtensions != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.endpoint != null ? this.endpoint.hashCode() : 0);
        result = 31 * result + (this.schema != null ? this.schema.hashCode() : 0);
        result = 31 * result + (this.schemaExtensions != null ? this.schemaExtensions.hashCode() : 0);
        return result;
    }

    public static class SchemaExtension {
        @Attribute(description="The URI of a schema extension.", isRequired=true, isCaseExact=true, mutability=AttributeDefinition.Mutability.READ_ONLY, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE, referenceTypes={"uri"})
        private URI schema;
        @Attribute(description="A Boolean value that specifies whether the schema extension is required for the resource type. If true, a resource of this type MUST include this schema extension and include any attributes declared as required in this schema extension. If false, a resource of this type MAY omit this schema extension", isRequired=true, mutability=AttributeDefinition.Mutability.READ_ONLY, returned=AttributeDefinition.Returned.DEFAULT)
        private boolean required;

        @JsonCreator
        public SchemaExtension(@JsonProperty(value="schema", required=true) URI schema, @JsonProperty(value="required", required=true) boolean required) {
            this.schema = schema;
            this.required = required;
        }

        public URI getSchema() {
            return this.schema;
        }

        public boolean isRequired() {
            return this.required;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SchemaExtension that = (SchemaExtension)o;
            if (this.required != that.required) {
                return false;
            }
            return !(this.schema != null ? !this.schema.equals(that.schema) : that.schema != null);
        }

        public int hashCode() {
            int result = this.schema != null ? this.schema.hashCode() : 0;
            result = 31 * result + (this.required ? 1 : 0);
            return result;
        }
    }
}

