/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.unboundid.scim2.common.utils;

import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.unboundid.scim2.common.utils.StaticUtils;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class CaseIgnoreMap
implements Map<String, JsonNode> {
    private final LinkedHashMap<CaseIgnoreKey, JsonNode> attributes;

    public CaseIgnoreMap() {
        this.attributes = new LinkedHashMap();
    }

    public CaseIgnoreMap(Map<String, JsonNode> map) {
        this.attributes = new LinkedHashMap(map.size());
        this.putAll((Map<? extends String, ? extends JsonNode>)map);
    }

    @Override
    public int size() {
        return this.attributes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.attributes.containsKey(new CaseIgnoreKey(key.toString()));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.attributes.containsValue(value);
    }

    @Override
    public JsonNode get(Object key) {
        return this.attributes.get(new CaseIgnoreKey(key.toString()));
    }

    @Override
    public JsonNode put(String key, JsonNode value) {
        return this.attributes.put(new CaseIgnoreKey(key), value);
    }

    @Override
    public JsonNode remove(Object key) {
        return (JsonNode)this.attributes.remove(new CaseIgnoreKey(key.toString()));
    }

    @Override
    public void putAll(Map<? extends String, ? extends JsonNode> m) {
        for (Map.Entry<? extends String, ? extends JsonNode> entry : m.entrySet()) {
            this.attributes.put(new CaseIgnoreKey(entry.getKey()), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.attributes.clear();
    }

    @Override
    public Set<String> keySet() {
        return new KeySet(this.attributes.keySet());
    }

    @Override
    public Collection<JsonNode> values() {
        return this.attributes.values();
    }

    @Override
    public Set<Map.Entry<String, JsonNode>> entrySet() {
        return new EntrySet(this.attributes.entrySet());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaseIgnoreMap that = (CaseIgnoreMap)o;
        return this.attributes.equals(that.attributes);
    }

    @Override
    public int hashCode() {
        return this.attributes.hashCode();
    }

    public String toString() {
        return this.attributes.toString();
    }

    private static class EntryIterator
    implements Iterator<Map.Entry<String, JsonNode>> {
        private final Iterator<Map.Entry<CaseIgnoreKey, JsonNode>> iterator;

        EntryIterator(Iterator<Map.Entry<CaseIgnoreKey, JsonNode>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<String, JsonNode> next() {
            Map.Entry<CaseIgnoreKey, JsonNode> entry = this.iterator.next();
            return new AbstractMap.SimpleEntry<String, JsonNode>(entry.getKey().getKey(), entry.getValue());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private static class EntrySet
    extends AbstractSet<Map.Entry<String, JsonNode>> {
        private final Set<Map.Entry<CaseIgnoreKey, JsonNode>> entries;

        EntrySet(Set<Map.Entry<CaseIgnoreKey, JsonNode>> entries) {
            this.entries = entries;
        }

        @Override
        public Iterator<Map.Entry<String, JsonNode>> iterator() {
            return new EntryIterator(this.entries.iterator());
        }

        @Override
        public int size() {
            return this.entries.size();
        }
    }

    private static class KeyIterator
    implements Iterator<String> {
        private final Iterator<CaseIgnoreKey> iterator;

        KeyIterator(Iterator<CaseIgnoreKey> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public String next() {
            return this.iterator.next().getKey();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private static class KeySet
    extends AbstractSet<String> {
        private final Set<CaseIgnoreKey> keys;

        KeySet(Set<CaseIgnoreKey> keys) {
            this.keys = keys;
        }

        @Override
        public Iterator<String> iterator() {
            return new KeyIterator(this.keys.iterator());
        }

        @Override
        public int size() {
            return this.keys.size();
        }
    }

    private static class CaseIgnoreKey {
        private final String key;

        CaseIgnoreKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CaseIgnoreKey that = (CaseIgnoreKey)o;
            return StaticUtils.toLowerCase(this.key).equals(StaticUtils.toLowerCase(that.key));
        }

        public int hashCode() {
            return StaticUtils.toLowerCase(this.key).hashCode();
        }
    }
}

