/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.client5.http.impl;

import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.client5.http.AuthenticationStrategy;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.client5.http.auth.AuthChallenge;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.client5.http.auth.AuthScheme;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.client5.http.auth.AuthSchemeFactory;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.client5.http.auth.ChallengeType;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.client5.http.config.RequestConfig;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.client5.http.protocol.HttpClientContext;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.annotation.Contract;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.config.Lookup;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.protocol.HttpContext;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.util.Args;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
public class DefaultAuthenticationStrategy
implements AuthenticationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAuthenticationStrategy.class);
    public static final DefaultAuthenticationStrategy INSTANCE = new DefaultAuthenticationStrategy();
    private static final List<String> DEFAULT_SCHEME_PRIORITY = Collections.unmodifiableList(Arrays.asList("Negotiate", "Kerberos", "NTLM", "Digest", "Basic"));

    @Override
    public List<AuthScheme> select(ChallengeType challengeType, Map<String, AuthChallenge> challenges, HttpContext context) {
        Collection<String> authPrefs;
        Args.notNull(challengeType, "ChallengeType");
        Args.notNull(challenges, "Map of auth challenges");
        Args.notNull(context, "HTTP context");
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        ArrayList<AuthScheme> options = new ArrayList<AuthScheme>();
        Lookup<AuthSchemeFactory> registry = clientContext.getAuthSchemeRegistry();
        if (registry == null) {
            LOG.debug("Auth scheme registry not set in the context");
            return options;
        }
        RequestConfig config = clientContext.getRequestConfig();
        Collection<String> collection = authPrefs = challengeType == ChallengeType.TARGET ? config.getTargetPreferredAuthSchemes() : config.getProxyPreferredAuthSchemes();
        if (authPrefs == null) {
            authPrefs = DEFAULT_SCHEME_PRIORITY;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Authentication schemes in the order of preference: {}", authPrefs);
        }
        for (String schemeName : authPrefs) {
            AuthChallenge challenge = challenges.get(schemeName.toLowerCase(Locale.ROOT));
            if (challenge != null) {
                AuthSchemeFactory authSchemeFactory = registry.lookup(schemeName);
                if (authSchemeFactory == null) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn("Authentication scheme {} not supported", (Object)schemeName);
                    continue;
                }
                AuthScheme authScheme = authSchemeFactory.create(context);
                options.add(authScheme);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Challenge for {} authentication scheme not available", (Object)schemeName);
        }
        return options;
    }
}

