/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.impl.nio;

import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.annotation.Contract;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.HttpHost;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.URIScheme;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.impl.nio.ClientHttp1IOEventHandler;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.impl.nio.ClientHttp1StreamDuplexerFactory;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.reactor.IOEventHandler;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.reactor.IOEventHandlerFactory;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.reactor.ProtocolIOSession;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.util.Args;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ClientHttp1IOEventHandlerFactory
implements IOEventHandlerFactory {
    private final ClientHttp1StreamDuplexerFactory streamDuplexerFactory;
    private final TlsStrategy tlsStrategy;
    private final Timeout handshakeTimeout;

    public ClientHttp1IOEventHandlerFactory(ClientHttp1StreamDuplexerFactory streamDuplexerFactory, TlsStrategy tlsStrategy, Timeout handshakeTimeout) {
        this.streamDuplexerFactory = Args.notNull(streamDuplexerFactory, "Stream duplexer factory");
        this.tlsStrategy = tlsStrategy;
        this.handshakeTimeout = handshakeTimeout;
    }

    @Override
    public IOEventHandler createHandler(ProtocolIOSession ioSession, Object attachment) {
        HttpHost host;
        if (this.tlsStrategy != null && ioSession.getInitialEndpoint() instanceof HttpHost && URIScheme.HTTPS.same((host = (HttpHost)ioSession.getInitialEndpoint()).getSchemeName())) {
            this.tlsStrategy.upgrade(ioSession, host, ioSession.getLocalAddress(), ioSession.getRemoteAddress(), attachment, this.handshakeTimeout);
        }
        return new ClientHttp1IOEventHandler(this.streamDuplexerFactory.create(ioSession));
    }
}

