/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.saas.pingone;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.crypto.Password;
import com.pingidentity.io.cpl.pingone.exception.ResourceException;
import com.pingidentity.io.cpl.pingone.exception.ResourceNotFoundException;
import com.pingidentity.io.cpl.pingone.exception.ServiceException;
import com.pingidentity.io.cpl.pingone.metadata.AttributeMetadata;
import com.pingidentity.io.cpl.pingone.metadata.ConnectionProfile;
import com.pingidentity.io.cpl.pingone.metadata.ProvisionerInformation;
import com.pingidentity.io.cpl.pingone.request.ConnectionFields;
import com.pingidentity.io.cpl.pingone.request.CreateMembershipsRequest;
import com.pingidentity.io.cpl.pingone.request.DeleteMembershipsRequest;
import com.pingidentity.io.cpl.pingone.request.GetAttributesRequest;
import com.pingidentity.io.cpl.pingone.request.GetConnectionProfilesRequest;
import com.pingidentity.io.cpl.pingone.request.GetInfoRequest;
import com.pingidentity.io.cpl.pingone.request.GetMembersOfGroupRequest;
import com.pingidentity.io.cpl.pingone.request.PageFields;
import com.pingidentity.io.cpl.pingone.resource.Group;
import com.pingidentity.io.cpl.pingone.resource.Membership;
import com.pingidentity.io.cpl.pingone.resource.ResourceAttributes;
import com.pingidentity.io.cpl.pingone.resource.ResourceType;
import com.pingidentity.io.cpl.pingone.resource.ResourceUniqueId;
import com.pingidentity.io.cpl.pingone.response.CreateMembershipsResponse;
import com.pingidentity.io.cpl.pingone.response.DeleteMembershipsResponse;
import com.pingidentity.io.cpl.pingone.response.GetAttributesResponse;
import com.pingidentity.io.cpl.pingone.response.GetConnectionProfilesResponse;
import com.pingidentity.io.cpl.pingone.response.GetMembersOfGroupResponse;
import com.pingidentity.io.cpl.pingone.response.MembershipAttempt;
import com.pingidentity.prov.saas.pingone.GroupsPluginWorker;
import com.pingidentity.prov.saas.pingone.metadata.MetadataService;
import com.pingidentity.prov.saas.pingone.request.groups.GroupUserRequestBuilderFactory;
import com.pingidentity.provisioner.domain.Channel;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerConfig;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerManager;
import com.pingidentity.provisioner.integrations.pingone.ConnectionFieldKey;
import com.pingidentity.provisioner.integrations.pingone.PingOneWorker;
import com.pingidentity.provisioner.integrations.pingone.ResourceFieldKey;
import com.pingidentity.provisioner.integrations.pingone.metadata.PingOneConnectionProfile;
import com.pingidentity.provisioner.integrations.pingone.pf.AccessTokenProviderException;
import com.pingidentity.provisioner.integrations.pingone.pf.DisabledAppException;
import com.pingidentity.provisioner.integrations.pingone.pf.PingOneEnvironmentUtil;
import com.pingidentity.provisioner.integrations.pingone.pf.ReflectedPingOneEnvironmentAccessor;
import com.pingidentity.provisioner.integrations.pingone.pf.ReflectionException;
import com.pingidentity.provisioner.integrations.pingone.pf.SaasParameterValidation;
import com.pingidentity.provisioner.integrations.pingone.pf.cache.AccessTokenCache;
import com.pingidentity.provisioner.integrations.pingone.pf.cache.AttributeMetadataCache;
import com.pingidentity.provisioner.integrations.pingone.pf.cache.PingOneAttributeMetadataCache;
import com.pingidentity.provisioner.integrations.pingone.pf.cpl.PingOneMetadataServiceFactory;
import com.pingidentity.provisioner.integrations.pingone.pf.cpl.PingOnePluginWorker;
import com.pingidentity.provisioner.integrations.pingone.pf.template.PingOneConfiguration;
import com.pingidentity.provisioner.integrations.pingone.pf.template.PingOneInformation;
import com.pingidentity.provisioner.saas.BaseSaasPlugin;
import com.pingidentity.provisioner.saas.SaasProvisionerPlugin;
import com.pingidentity.provisioner.sdk.AbstractSaasPluginWithGroups;
import com.pingidentity.provisioner.sdk.SaasGroupData;
import com.pingidentity.provisioner.sdk.SaasPluginException;
import com.pingidentity.provisioner.sdk.SaasPluginFieldInfo;
import com.pingidentity.provisioner.sdk.SaasUserData;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.FieldList;
import org.sourceid.saml20.adapter.conf.SimpleFieldList;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;

public class ProvisionerSDKPlugin
extends AbstractSaasPluginWithGroups {
    private static final long serialVersionUID = -2088797560933737361L;
    private final boolean REQUEST_NEW_TOKEN = true;
    private final boolean REQUEST_CACHED_TOKEN = false;
    private static final int MAX_THREADS = 1;
    private static final String TRUE = "true";
    private transient GroupsPluginWorker worker;
    private transient PingOneWorker cplWorker;
    private transient MetadataService metadataService;
    private static Logger logger;
    private final AttributeMetadataCache CACHE = PingOneAttributeMetadataCache.getInstance();
    private final AccessTokenCache accessTokenCache = AccessTokenCache.getInstance();
    private transient Optional<PingOneInformation> configInfo;
    private static boolean supportsGetMetadata;
    private static boolean supportsPluginServiceAssociation;

    public ProvisionerSDKPlugin() {
        ProvisionerSDKPlugin.setLogger(Logger.getLogger(((Object)((Object)this)).getClass()));
        this.cplWorker = new PingOneWorker();
        ProvisionerInformation info = this.cplWorker.getInfo(new GetInfoRequest()).getInformation();
        ConnectionProfile profile = this.getDefaultConnectionProfile();
        AttributeMetadata attributeMetadata = this.populateAttributeMetadata(new GetAttributesRequest());
        try {
            ObjectMapper mapper = new ObjectMapper();
            PingOneConfiguration config = (PingOneConfiguration)mapper.readValue(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("pingone-attributes.json"), PingOneConfiguration.class);
            this.configInfo = Optional.ofNullable(config.getProvisionerInformation());
        }
        catch (IOException mapper) {
            // empty catch block
        }
        if (this.configInfo.isPresent() && info != null) {
            info.setKey(this.configInfo.get().getKey());
            info.setDisplayName(this.configInfo.get().getDisplayName());
            info.setVersion(this.configInfo.get().getVersion());
            info.setImageUrl(this.configInfo.get().getImageUrl());
            info.setIdentityProvider(this.configInfo.get().isIdentityProvider());
            info.setBaseURLRequired(this.configInfo.get().isBaseUrlRequired());
            info.setConnectionInformationRequired(this.configInfo.get().isConnectionInformationRequired());
        }
        PingOneMetadataServiceFactory metadataServiceFactory = new PingOneMetadataServiceFactory(info, profile, attributeMetadata);
        GroupUserRequestBuilderFactory requestBuilderFactory = new GroupUserRequestBuilderFactory(metadataServiceFactory, ResourceFieldKey.ENABLED.getLabel(), Boolean.TRUE, ResourceFieldKey.GROUP_NAME.getLabel());
        this.worker = new PingOnePluginWorker(this.cplWorker, requestBuilderFactory, ResourceFieldKey.GROUP_NAME.getLabel());
        this.metadataService = metadataServiceFactory.make();
        boolean isPf11OrHigher = SaasParameterValidation.isClassAvailable();
        if (isPf11OrHigher) {
            new SaasParameterValidation((BaseSaasPlugin)this);
        }
    }

    public ProvisionerSDKPlugin(Logger log, GroupsPluginWorker worker, PingOneWorker cplWorker, MetadataService uiService) {
        ProvisionerSDKPlugin.setLogger(log);
        this.worker = worker;
        this.cplWorker = cplWorker;
        this.metadataService = uiService;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger logger) {
        ProvisionerSDKPlugin.logger = logger;
    }

    public String getSaasUserIdFieldName() {
        return ResourceFieldKey.getPrimaryId().getLabel();
    }

    public String getSaasUsernameFieldCode() {
        return ResourceFieldKey.getSecondaryId().getLabel();
    }

    public SaasUserData getUser(String saasUserGuid, String saasUsername) throws SaasPluginException {
        ProvisionerSDKPlugin.getLogger().debug((Object)"+ getUser()");
        String saasGuid = saasUserGuid;
        ConnectionFields connectionFields = this.makeConnectionFields(false);
        if (saasGuid == null) {
            saasGuid = "";
        }
        SaasUserData saasUserData = new SaasUserData(saasGuid);
        ProvisionerSDKPlugin.getLogger().info((Object)String.format("Using %s: [%s] for getUser()", this.getSaasUsernameFieldCode(), saasUsername));
        saasUserData.addAttribute(this.getSaasUsernameFieldCode(), saasUsername);
        try {
            saasUserData = this.worker.executeGetUser(saasUserData, connectionFields);
        }
        catch (ServiceException e) {
            throw new SaasPluginException(e.getFormattedMessage());
        }
        catch (ResourceException e) {
            throw new SaasPluginException(e.getFormattedMessage());
        }
        if (saasUserData == null) {
            ProvisionerSDKPlugin.getLogger().info((Object)("User [" + saasUsername + "] was not found in target"));
        } else {
            ProvisionerSDKPlugin.getLogger().info((Object)("User [" + saasUsername + "] was found in target"));
        }
        ProvisionerSDKPlugin.getLogger().debug((Object)"- getUser()");
        return saasUserData;
    }

    public String createUser(SaasUserData userData) throws SaasPluginException {
        ProvisionerSDKPlugin.getLogger().debug((Object)"+ createUser()");
        String userGuid = null;
        ConnectionFields connectionFields = this.makeConnectionFields(false);
        if (connectionFields.containsKey(ConnectionFieldKey.CREATE_USERS_PROV_OPT.getKey()) && !((String)connectionFields.get(ConnectionFieldKey.CREATE_USERS_PROV_OPT.getKey())).equalsIgnoreCase(TRUE)) {
            ProvisionerSDKPlugin.getLogger().warn((Object)("Unable to create user as the Create Users flag is set to false. User details: " + userData.getAttributeFirstValue(ResourceFieldKey.getSecondaryId().getLabel())));
        } else if (connectionFields.containsKey(ConnectionFieldKey.PROVISION_DISABLED_USERS_PROV_OPT.getKey()) && !((String)connectionFields.get(ConnectionFieldKey.PROVISION_DISABLED_USERS_PROV_OPT.getKey())).equalsIgnoreCase(TRUE) && !userData.isAccountEnabled()) {
            ProvisionerSDKPlugin.getLogger().warn((Object)("Unable to create user as user is disabled and the Provision Disabled Users flag is set to false. User details: " + userData.getAttributeFirstValue(ResourceFieldKey.getSecondaryId().getLabel())));
        } else {
            try {
                userGuid = this.worker.executeCreateUser(userData, connectionFields);
                ProvisionerSDKPlugin.getLogger().info((Object)"User was successfully created in target");
            }
            catch (ServiceException e) {
                throw new SaasPluginException(e.getFormattedMessage());
            }
            catch (ResourceException e) {
                throw new SaasPluginException(e.getFormattedMessage());
            }
        }
        ProvisionerSDKPlugin.getLogger().debug((Object)"- createUser()");
        return userGuid;
    }

    public String updateUser(SaasUserData oldUserData, SaasUserData newUserData) throws SaasPluginException {
        String id = oldUserData.getSaasUserGuid();
        ConnectionFields connectionFields = this.makeConnectionFields(false);
        newUserData = this.cloneSaasUserDataWithSaasUserGuid(oldUserData.getSaasUserGuid(), newUserData);
        if (!newUserData.isAccountEnabled()) {
            if (connectionFields.containsKey(ConnectionFieldKey.REMOVE_ACTION.getKey()) && "Delete".equalsIgnoreCase((String)connectionFields.get(ConnectionFieldKey.REMOVE_ACTION.getKey()))) {
                this.deleteUser(newUserData);
            } else {
                this.disableUser(newUserData);
            }
        } else {
            id = this.executeUpdateUser(newUserData);
        }
        return id;
    }

    public boolean doesGroupExist(SaasGroupData saasGroup) throws SaasPluginException {
        ProvisionerSDKPlugin.getLogger().debug((Object)"+ getGroup()");
        SaasGroupData data = null;
        boolean groupFound = false;
        try {
            data = this.worker.executeGetGroup(saasGroup, this.makeConnectionFields(false));
        }
        catch (ServiceException e) {
            throw new SaasPluginException(e.getFormattedMessage(), (Throwable)e);
        }
        catch (ResourceNotFoundException e) {
            ProvisionerSDKPlugin.getLogger().info((Object)String.format("Group [%s] was not found in target", saasGroup.getName()));
        }
        catch (ResourceException e) {
            throw new SaasPluginException(e.getFormattedMessage(), (Throwable)e);
        }
        if (data != null) {
            ProvisionerSDKPlugin.getLogger().info((Object)String.format("Group [%s] was found in target", saasGroup.getName()));
            groupFound = true;
        } else {
            ProvisionerSDKPlugin.getLogger().info((Object)String.format("Group [%s] was not found in target", saasGroup.getName()));
        }
        ProvisionerSDKPlugin.getLogger().debug((Object)"- getGroup()");
        return groupFound;
    }

    public String updateGroup(SaasGroupData saasGroup, boolean mergeMembership) throws SaasPluginException {
        String groupGuid;
        ProvisionerSDKPlugin.getLogger().debug((Object)"+ updateGroup()");
        ConnectionFields connectionFields = this.makeConnectionFields(true);
        SaasGroupData updateSaasGroup = saasGroup;
        if (!saasGroup.hasGuid()) {
            try {
                groupGuid = this.getGroupGuid(connectionFields, saasGroup);
                updateSaasGroup = new SaasGroupData(groupGuid, saasGroup.getName());
                updateSaasGroup.setMembersIterator(saasGroup.getMembersIterator());
            }
            catch (ServiceException e) {
                throw new SaasPluginException(e.getFormattedMessage());
            }
            catch (ResourceException e) {
                if (e instanceof ResourceNotFoundException) {
                    ProvisionerSDKPlugin.getLogger().debug((Object)String.format("Group [%s] was not found in target", saasGroup.getName()));
                }
                throw new SaasPluginException(e.getFormattedMessage());
            }
        }
        try {
            groupGuid = this.worker.executeUpdateGroup(updateSaasGroup, connectionFields);
            ProvisionerSDKPlugin.getLogger().info((Object)"Group was successfully updated in target");
        }
        catch (ServiceException e) {
            throw new SaasPluginException(e.getFormattedMessage());
        }
        catch (ResourceException e) {
            throw new SaasPluginException(e.getFormattedMessage());
        }
        List<Exception> exceptions = this.resolveMembers(connectionFields, updateSaasGroup, new ResourceUniqueId(groupGuid));
        if (!exceptions.isEmpty()) {
            throw new SaasPluginException(exceptions.get(0).getMessage());
        }
        ProvisionerSDKPlugin.getLogger().debug((Object)"- updateGroup()");
        return groupGuid;
    }

    public String createGroup(SaasGroupData saasGroup) throws SaasPluginException {
        String groupGuid;
        ProvisionerSDKPlugin.getLogger().debug((Object)"+ createGroup()");
        ConnectionFields connectionFields = this.makeConnectionFields(true);
        try {
            groupGuid = this.worker.executeCreateGroup(saasGroup, connectionFields);
            ProvisionerSDKPlugin.getLogger().info((Object)"Group was successfully created in target");
        }
        catch (ServiceException e) {
            throw new SaasPluginException(e.getFormattedMessage());
        }
        catch (ResourceException e) {
            throw new SaasPluginException(e.getFormattedMessage());
        }
        List<Exception> exceptions = this.resolveMembers(connectionFields, saasGroup, new ResourceUniqueId(groupGuid));
        if (!exceptions.isEmpty()) {
            throw new SaasPluginException(exceptions.get(0).getMessage());
        }
        ProvisionerSDKPlugin.getLogger().debug((Object)"- createGroup()");
        return groupGuid;
    }

    public void deleteGroup(SaasGroupData saasGroup) throws SaasPluginException {
        ProvisionerSDKPlugin.getLogger().debug((Object)"+ deleteGroup()");
        if (saasGroup.getGuid() == null || saasGroup.getGuid().isEmpty()) {
            ProvisionerSDKPlugin.getLogger().info((Object)String.format("Group [%s] had no id persisted in the database, no action was taken on the SaaS.", saasGroup.getName()));
            ProvisionerSDKPlugin.getLogger().debug((Object)"- deleteGroup()");
            return;
        }
        try {
            this.worker.executeDeleteGroup(saasGroup, this.makeConnectionFields(false));
            ProvisionerSDKPlugin.getLogger().info((Object)String.format("Group [%s] was successfully deleted in target", saasGroup.getName()));
        }
        catch (ServiceException e) {
            throw new SaasPluginException(e.getFormattedMessage(), (Throwable)e);
        }
        catch (ResourceException e) {
            throw new SaasPluginException(e.getFormattedMessage(), (Throwable)e);
        }
        ProvisionerSDKPlugin.getLogger().debug((Object)"- deleteGroup()");
    }

    public boolean isConfiguredForGroups() {
        return true;
    }

    public boolean isUsingDnAsGroupName() {
        return false;
    }

    public void initSaasConnection(List<Field> fieldList) throws SaasPluginException {
        if (fieldList != null && !fieldList.isEmpty()) {
            this._parameters = new SimpleFieldList(fieldList);
        }
        this.refreshDependencies();
    }

    public void checkSaasConnection() throws SaasPluginException {
        ProvisionerSDKPlugin.getLogger().debug((Object)"+ checkSaasConnection()");
        try {
            this.worker.executeCheckConnection(this.makeConnectionFields(false));
        }
        catch (ServiceException e) {
            throw new SaasPluginException(e.getFormattedMessage());
        }
        ProvisionerSDKPlugin.getLogger().debug((Object)"- checkSaasConnection()");
    }

    public void closeSaasConnection() throws SaasPluginException {
    }

    public List<FieldDescriptor> getConnectionParameterDescriptors() {
        return this.metadataService.getConnectionDescriptors();
    }

    public String getId() {
        return this.metadataService.getName();
    }

    public String getDescription() {
        return this.metadataService.getDescription();
    }

    public List<SaasPluginFieldInfo> getFieldInfo() throws SaasPluginException {
        return this.metadataService.getAttributeDescriptors();
    }

    public Properties loadDefaultMappings() throws IOException {
        return this.metadataService.getDefaultMappings();
    }

    public int getDefaultMaxThreads() {
        return 1;
    }

    public Map<String, Object> getMetadata() {
        if (supportsGetMetadata && supportsPluginServiceAssociation) {
            try {
                Class<?> pluginMetadataKeysClass = Class.forName("com.pingidentity.sdk.PluginMetadataKeys");
                Class<?> pluginServiceAssociationClass = Class.forName("com.pingidentity.sdk.PluginServiceAssociation");
                Constructor<?> pluginServiceAssociationConstructor = pluginServiceAssociationClass.getConstructor(String.class, String.class);
                return Collections.singletonMap((String)pluginMetadataKeysClass.getField("PING_ONE_SERVICE_ASSOCIATION").get(null), pluginServiceAssociationConstructor.newInstance("Outbound Provisioning Connector", pluginServiceAssociationClass.getField("DIRECTORY_SERVICE_DISPLAY_NAME").get(null)));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return Collections.emptyMap();
    }

    private SaasUserData cloneSaasUserDataWithSaasUserGuid(String saasGuid, SaasUserData saasUserData) {
        SaasUserData clone = new SaasUserData(saasGuid);
        clone.setAccountEnabled(saasUserData.isAccountEnabled());
        clone.setAttributeMap(saasUserData.getAttributeMap());
        clone.setInternalGuid(saasUserData.getInternalGuid());
        return clone;
    }

    private String executeUpdateUser(SaasUserData userData) throws SaasPluginException {
        ProvisionerSDKPlugin.getLogger().debug((Object)"+ executeUpdateUser()");
        ConnectionFields connectionFields = this.makeConnectionFields(false);
        String saasGuid = null;
        if (connectionFields.containsKey(ConnectionFieldKey.UPDATE_USERS_PROV_OPT.getKey()) && !((String)connectionFields.get(ConnectionFieldKey.UPDATE_USERS_PROV_OPT.getKey())).equalsIgnoreCase(TRUE)) {
            ProvisionerSDKPlugin.getLogger().warn((Object)("Unable to update user as the Update Users flag is set to false. User details: " + userData.getAttributeFirstValue(ResourceFieldKey.getSecondaryId().getLabel())));
        } else {
            try {
                saasGuid = this.worker.executeUpdateUser(userData, connectionFields);
                ProvisionerSDKPlugin.getLogger().info((Object)"User was successfully updated in target");
            }
            catch (ServiceException e) {
                throw new SaasPluginException(e.getFormattedMessage());
            }
            catch (ResourceException e) {
                throw new SaasPluginException(e.getFormattedMessage());
            }
        }
        ProvisionerSDKPlugin.getLogger().debug((Object)"- executeUpdateUser()");
        return saasGuid;
    }

    private String disableUser(SaasUserData userData) throws SaasPluginException {
        ProvisionerSDKPlugin.getLogger().debug((Object)"+ disableUser()");
        ConnectionFields connectionFields = this.makeConnectionFields(false);
        String saasGuid = null;
        userData.setAccountEnabled(false);
        if (connectionFields.containsKey(ConnectionFieldKey.REMOVE_USERS_PROV_OPT.getKey()) && !((String)connectionFields.get(ConnectionFieldKey.REMOVE_USERS_PROV_OPT.getKey())).equalsIgnoreCase(TRUE)) {
            ProvisionerSDKPlugin.getLogger().warn((Object)("Unable to disable user as the Remove User flag is set to false. User details: " + userData.getAttributeFirstValue(ResourceFieldKey.getSecondaryId().getLabel())));
        } else {
            try {
                saasGuid = this.worker.executeUpdateUser(userData, connectionFields);
                ProvisionerSDKPlugin.getLogger().info((Object)"User was successfully disabled in target");
            }
            catch (ServiceException e) {
                throw new SaasPluginException(e.getFormattedMessage());
            }
            catch (ResourceException e) {
                throw new SaasPluginException(e.getFormattedMessage());
            }
        }
        ProvisionerSDKPlugin.getLogger().debug((Object)"- disableUser()");
        return saasGuid;
    }

    private void deleteUser(SaasUserData userData) throws SaasPluginException {
        ProvisionerSDKPlugin.getLogger().debug((Object)"+ deleteUser()");
        ConnectionFields connectionFields = this.makeConnectionFields(false);
        userData.setAccountEnabled(false);
        if (connectionFields.containsKey(ConnectionFieldKey.REMOVE_USERS_PROV_OPT.getKey()) && !((String)connectionFields.get(ConnectionFieldKey.REMOVE_USERS_PROV_OPT.getKey())).equalsIgnoreCase(TRUE)) {
            ProvisionerSDKPlugin.getLogger().warn((Object)("Unable to delete user as the Remove User flag is set to false. User details: " + userData.getAttributeFirstValue(ResourceFieldKey.getSecondaryId().getLabel())));
        } else {
            try {
                this.worker.executeDeleteUser(userData, connectionFields);
                ProvisionerSDKPlugin.getLogger().info((Object)"User was successfully deleted in target");
            }
            catch (ServiceException e) {
                throw new SaasPluginException(e.getFormattedMessage());
            }
            catch (ResourceException e) {
                throw new SaasPluginException(e.getFormattedMessage());
            }
        }
        ProvisionerSDKPlugin.getLogger().debug((Object)"- deleteUser()");
    }

    private ConnectionFields makeConnectionFields(boolean requestNewToken) throws SaasPluginException {
        ConnectionFields connectionFields = new ConnectionFields();
        Optional<Field> p1EnvFieldOptional = this._parameters.getFields().stream().filter(field -> field != null && field.getName() != null && "PINGONE_ENVIRONMENT".equalsIgnoreCase(field.getName())).findFirst();
        if (p1EnvFieldOptional.isPresent()) {
            boolean isFieldValueNullOrEmpty;
            Field p1EnvField = p1EnvFieldOptional.get();
            String p1FieldName = p1EnvField.getName();
            String p1FieldValue = p1EnvField.getValue();
            boolean isFieldNameNullOrEmpty = p1FieldName == null || p1FieldName.isEmpty();
            boolean bl = isFieldValueNullOrEmpty = p1FieldValue == null || p1FieldValue.isEmpty();
            if (!isFieldNameNullOrEmpty && !isFieldValueNullOrEmpty) {
                try {
                    ReflectedPingOneEnvironmentAccessor accessor = new ReflectedPingOneEnvironmentAccessor(p1FieldValue);
                    connectionFields.put(ConnectionFieldKey.ACCESS_TOKEN.getKey(), this.accessTokenCache.getToken(accessor, p1FieldValue, requestNewToken));
                    connectionFields.put(ConnectionFieldKey.ENV_ID.getKey(), accessor.getEnvironmentId());
                    connectionFields.put(ConnectionFieldKey.MGMT_URL.getKey(), accessor.getManagementEndpoint());
                    connectionFields.put(ConnectionFieldKey.AUTH_URL.getKey(), accessor.getAuthenticationEndpoint());
                }
                catch (DisabledAppException e) {
                    throw new SaasPluginException(e.getMessage(), (Throwable)e);
                }
                catch (ReflectionException e) {
                    logger.debug((Object)"PingFederate version is less than 10.2, using legacy configuration options.", (Throwable)e);
                }
                catch (AccessTokenProviderException e) {
                    logger.warn((Object)"Encountered exception while retrieving Access Token.", (Throwable)e);
                    throw new SaasPluginException(e.getMessage(), (Throwable)e);
                }
            }
        }
        boolean isPf102OrHigher = ReflectedPingOneEnvironmentAccessor.isClassAvailable();
        for (Field field2 : this._parameters.getFields()) {
            boolean isFieldValueNullOrEmpty;
            String fieldName = field2.getName();
            String fieldValue = field2.getValue();
            boolean bl = isFieldValueNullOrEmpty = fieldValue == null || fieldValue.isEmpty();
            if (ConnectionFieldKey.CLIENT_SECRET.getKey().equalsIgnoreCase(fieldName) && isPf102OrHigher && !isFieldValueNullOrEmpty) {
                fieldValue = Password.decodeAndDeobfuscate((String)fieldValue);
            }
            connectionFields.put(fieldName, fieldValue);
        }
        connectionFields.values().removeIf(Objects::isNull);
        return connectionFields;
    }

    private AttributeMetadata populateAttributeMetadata(GetAttributesRequest request) {
        String channelId = this.introspectChannelId(request.getConnectionFields());
        AttributeMetadata attributeMetadata = this.CACHE.get(channelId);
        if (attributeMetadata == null) {
            boolean hasConnectionFields;
            logger.debug((Object)"AttributeMetadataCache: Miss");
            GetAttributesResponse attrResp = this.cplWorker.getAttributes(request);
            attributeMetadata = attrResp.getAttributeMetadata();
            boolean bl = hasConnectionFields = !request.getConnectionFields().isEmpty();
            if (hasConnectionFields && !attrResp.hasServiceExceptions()) {
                logger.debug((Object)"AttributeMetadataCache: Populating");
                this.CACHE.put(channelId, attributeMetadata);
            }
        }
        return attributeMetadata;
    }

    private String introspectChannelId(ConnectionFields cf) {
        if (cf == null || cf.isEmpty()) {
            return "0";
        }
        for (ProvisionerConfig config : ProvisionerManager.getProvisionerConfigs()) {
            List channels = config.getChannels();
            if (channels == null || channels.isEmpty()) continue;
            for (Channel dChannel : channels) {
                List channelConnectionFields = config.getTarget().getParameterValues().getFields();
                HashMap channelMap = new HashMap();
                channelConnectionFields.forEach(f -> channelMap.put(f.getName(), f.getValue()));
                if (!cf.equals(channelMap)) continue;
                return Integer.toString(dChannel.getId());
            }
        }
        return "0";
    }

    private void refreshDependencies() throws SaasPluginException {
        ProvisionerInformation info = this.cplWorker.getInfo(new GetInfoRequest()).getInformation();
        ConnectionProfile profile = this.getDefaultConnectionProfile();
        GetAttributesRequest request = new GetAttributesRequest(this.makeConnectionFields(false));
        AttributeMetadata attributeMetadata = this.populateAttributeMetadata(request);
        PingOneMetadataServiceFactory metadataServiceFactory = new PingOneMetadataServiceFactory(info, profile, attributeMetadata);
        this.metadataService = metadataServiceFactory.make();
        GroupUserRequestBuilderFactory requestBuilderFactory = new GroupUserRequestBuilderFactory(metadataServiceFactory, ResourceFieldKey.ENABLED.getLabel(), Boolean.TRUE, ResourceFieldKey.GROUP_NAME.getLabel());
        this.worker = new PingOnePluginWorker(this.cplWorker, requestBuilderFactory, ResourceFieldKey.GROUP_NAME.getLabel());
    }

    private String getGroupGuid(ConnectionFields connectionFields, SaasGroupData saasGroup) throws ServiceException, ResourceException {
        ProvisionerSDKPlugin.getLogger().debug((Object)String.format("Group [%s] does not have a Guid. Getting Group Guid from target.", saasGroup.getName()));
        SaasGroupData group = this.worker.executeGetGroup(saasGroup, connectionFields);
        ProvisionerSDKPlugin.getLogger().debug((Object)String.format("Group [%s] with Guid of [%s] was found in target.", group.getName(), group.getGuid()));
        return group.getGuid();
    }

    private List<Exception> resolveMembers(ConnectionFields connectionFields, SaasGroupData requestGroup, ResourceUniqueId groupId) {
        ProvisionerSDKPlugin.getLogger().debug((Object)"+ resolveMembers()");
        ArrayList<String> sourceMemberIds = this.getMembers(requestGroup.getMembersIterator());
        ArrayList<String> targetMemberIds = new ArrayList<String>();
        HashMap<String, Membership> memberships = new HashMap<String, Membership>();
        ArrayList<Exception> allExceptions = new ArrayList<Exception>();
        PageFields pageFields = new PageFields();
        boolean nextPage = true;
        while (nextPage) {
            Group group = new Group(groupId);
            group.getResourceAttributes().add(ResourceFieldKey.GROUP_NAME.getLabel(), requestGroup.getName());
            GetMembersOfGroupRequest request = new GetMembersOfGroupRequest(connectionFields, group, pageFields);
            GetMembersOfGroupResponse response = (GetMembersOfGroupResponse)this.cplWorker.doWork(request);
            if (!response.getServiceExceptions().isEmpty()) {
                for (ServiceException e : response.getServiceExceptions()) {
                    ProvisionerSDKPlugin.getLogger().error((Object)e.getFormattedMessage());
                    allExceptions.add(e);
                }
                return allExceptions;
            }
            for (Membership membership : response.getMemberships()) {
                String userId = membership.getMemberId().getId();
                targetMemberIds.add(userId);
                memberships.put(userId, membership);
                ProvisionerSDKPlugin.getLogger().debug((Object)String.format("Source group contains user with id [%s]", userId));
            }
            if (!response.getPageFields().isEmpty()) {
                pageFields = response.getPageFields();
                continue;
            }
            nextPage = false;
        }
        try {
            ArrayList membersToAdd = (ArrayList)sourceMemberIds.clone();
            membersToAdd.removeAll(targetMemberIds);
            ArrayList<Exception> createExceptions = this.createMemberships(membersToAdd, groupId, connectionFields);
            if (!createExceptions.isEmpty()) {
                allExceptions.addAll(createExceptions);
            }
            ArrayList membersToRemove = (ArrayList)targetMemberIds.clone();
            membersToRemove.removeAll(sourceMemberIds);
            ArrayList<Exception> removeExceptions = this.removeMemberships(membersToRemove, memberships, connectionFields);
            if (!removeExceptions.isEmpty()) {
                allExceptions.addAll(removeExceptions);
            }
        }
        catch (Exception e) {
            ProvisionerSDKPlugin.getLogger().error((Object)e);
        }
        ProvisionerSDKPlugin.getLogger().debug((Object)"- resolveMembers()");
        return allExceptions;
    }

    private ArrayList<Exception> createMemberships(ArrayList<String> memberIds, ResourceUniqueId groupId, ConnectionFields connectionFields) {
        ProvisionerSDKPlugin.getLogger().debug((Object)"+ createMemberships()");
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (String id : memberIds) {
            ResourceAttributes membershipAttributes = new ResourceAttributes();
            membershipAttributes.add(ResourceFieldKey.GROUP_ID.getLabel(), groupId.getId());
            membershipAttributes.add(ResourceFieldKey.GROUP_MEMBER_ID.getLabel(), id);
            Membership membership = new Membership(membershipAttributes, groupId, new ResourceUniqueId(id), ResourceType.USER);
            CreateMembershipsRequest request = new CreateMembershipsRequest(connectionFields, membership);
            CreateMembershipsResponse response = (CreateMembershipsResponse)this.cplWorker.doWork(request);
            if (response.hasServiceExceptions()) {
                for (ServiceException e : response.getServiceExceptions()) {
                    ProvisionerSDKPlugin.getLogger().error((Object)e.getFormattedMessage());
                    exceptions.add(e);
                }
                continue;
            }
            for (MembershipAttempt attempt : response.getMembershipAttempts()) {
                if (attempt.hasResourceExceptions()) {
                    for (ResourceException e : attempt.getResourceExceptions()) {
                        ProvisionerSDKPlugin.getLogger().error((Object)e.getFormattedMessage());
                        exceptions.add(e);
                    }
                    continue;
                }
                ProvisionerSDKPlugin.getLogger().info((Object)String.format("User with id [%s] successfully added to group.", id));
            }
        }
        ProvisionerSDKPlugin.getLogger().debug((Object)"- createMemberships()");
        return exceptions;
    }

    private ArrayList<Exception> removeMemberships(ArrayList<String> memberIds, HashMap<String, Membership> memberships, ConnectionFields connectionFields) {
        ProvisionerSDKPlugin.getLogger().debug((Object)"+ removeMemberships()");
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (String id : memberIds) {
            Membership membership = memberships.get(id);
            if (membership == null) {
                ProvisionerSDKPlugin.getLogger().error((Object)String.format("Unable to remove user with id [%s] from group", id));
                continue;
            }
            DeleteMembershipsRequest request = new DeleteMembershipsRequest(connectionFields, membership);
            DeleteMembershipsResponse response = (DeleteMembershipsResponse)this.cplWorker.doWork(request);
            if (response.hasServiceExceptions()) {
                for (ServiceException e : response.getServiceExceptions()) {
                    ProvisionerSDKPlugin.getLogger().error((Object)e.getFormattedMessage());
                    exceptions.add(e);
                }
                continue;
            }
            for (MembershipAttempt attempt : response.getMembershipAttempts()) {
                if (attempt.hasResourceExceptions()) {
                    for (ResourceException e : attempt.getResourceExceptions()) {
                        ProvisionerSDKPlugin.getLogger().error((Object)e.getFormattedMessage());
                        exceptions.add(e);
                    }
                    continue;
                }
                ProvisionerSDKPlugin.getLogger().info((Object)String.format("User with id [%s] successfully removed from group.", id));
            }
        }
        ProvisionerSDKPlugin.getLogger().debug((Object)"- removeMemberships()");
        return exceptions;
    }

    private ArrayList<String> getMembers(Iterator<SaasUserData> membersIterator) {
        ArrayList<String> sourceIds = new ArrayList<String>();
        if (membersIterator == null) {
            return sourceIds;
        }
        try {
            while (membersIterator.hasNext()) {
                SaasUserData data = membersIterator.next();
                if (data.getSaasUserGuid() == null) continue;
                sourceIds.add(data.getSaasUserGuid());
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        return sourceIds;
    }

    public List<FieldDescriptor> getConfiguredParameterDescriptors(FieldList fieldList) {
        List<FieldDescriptor> fieldDescriptors = this.metadataService.getConnectionDescriptors();
        if (StringUtils.isBlank((String)fieldList.getFieldValue("PINGONE_ENVIRONMENT"))) {
            PingOneEnvironmentUtil.showLegacyPingOneEnvironmentFields(fieldDescriptors);
        }
        return fieldDescriptors;
    }

    private ConnectionProfile getDefaultConnectionProfile() {
        GetConnectionProfilesResponse response = this.cplWorker.getConnectionProfiles(new GetConnectionProfilesRequest());
        String name = PingOneConnectionProfile.OAUTH_CLIENT_CREDENTIALS.getName();
        return response.getConnectionProfiles().stream().filter(profile -> name.equals(profile.getName())).findFirst().orElseThrow(() -> {
            String msg = String.format("Default connection profile [%s] was not found.", name);
            ProvisionerSDKPlugin.getLogger().error((Object)msg);
            return new IllegalStateException(msg);
        });
    }

    static {
        Method[] methods = SaasProvisionerPlugin.class.getMethods();
        if (Arrays.stream(methods).anyMatch(m -> "getMetadata".equals(m.getName()))) {
            supportsGetMetadata = true;
        }
        try {
            Class.forName("com.pingidentity.sdk.PluginServiceAssociation");
            supportsPluginServiceAssociation = true;
        }
        catch (ClassNotFoundException ignored) {
            supportsPluginServiceAssociation = false;
        }
    }
}

