/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.SaaSAttrGroupMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.SaaSAttrMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.SaaSAttrSingleMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.SaaSChannelTasklet;
import com.pingidentity.fsm.tasklet.impl.SaaSManagementTasklet;
import com.pingidentity.provisioner.domain.Channel;
import com.pingidentity.provisioner.domain.IdentityMapping;
import com.pingidentity.provisioner.domain.IdentityMappingField;
import com.pingidentity.provisioner.domain.mgmt.FieldInfoManager;
import com.pingidentity.provisioner.domain.target.SaasTarget;
import com.pingidentity.provisioner.saas.SaasException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class SaaSAttrMappingMgmtState
extends TaskletListState {
    private static final long serialVersionUID = 2L;
    Channel channel;
    List<IdentityMappingField> identityMapping;
    private String userNameFieldCode;

    public SaaSAttrMappingMgmtState(IWizard owner) {
        super(owner);
        this.setMenuName("Attribute Mapping");
    }

    public void populate(Object dataFromDisk) {
        this.channel = (Channel)dataFromDisk;
        this.identityMapping = this.channel.getIdentityMapping();
        this.userNameFieldCode = this.channel.getSaasUsernameFieldCode();
        this.deleteAllTasklets();
        this.createTasklets(this.identityMapping);
    }

    public void edit(Integer taskletToEdit, IRequestCycle cycle) {
        List taskletList = this.getTasklets();
        Tasklet tasklet = (Tasklet)taskletList.get(taskletToEdit);
        tasklet.resetCurrentStateToSourceState();
        tasklet.markProtocolImgAvailable(this.getParent().isProtocolImgAvailable());
        this.loadTasklet(tasklet);
    }

    public boolean save(Object dataToDisk) {
        ArrayList<IdentityMappingField> identityMappingFields = new ArrayList<IdentityMappingField>();
        for (Tasklet tasklet : this.getTasklets()) {
            SaaSAttrMappingTasklet saaSAttrMappingTasklet = (SaaSAttrMappingTasklet)tasklet;
            identityMappingFields.addAll(saaSAttrMappingTasklet.getIdentityMappingFields());
        }
        Channel channel = (Channel)dataToDisk;
        channel.getIdentityMapping().clear();
        channel.getIdentityMapping().addAll(identityMappingFields);
        channel.setSaasUsernameFieldCode(this.userNameFieldCode);
        return true;
    }

    public void onStateActivated() {
        if (this.channel == null && this.getTasklets().isEmpty()) {
            String sourceId = ((SaaSChannelTasklet)this.getParent()).getSelectedDataSource().getId();
            SaasTarget target = ((SaaSChannelTasklet)this.getParent()).getSaasTarget();
            LdapDataSource ldapSource = MgmtFactory.getDataSourceManager().getLdapDataSource(sourceId);
            try {
                this.userNameFieldCode = FieldInfoManager.getInstance().getSaasUsernameFieldCode(target);
                this.identityMapping = IdentityMapping.getDefaultIdentityMapping((String)ldapSource.getLdapType().name(), (SaasTarget)target);
                this.createTasklets(this.identityMapping);
            }
            catch (SaasException e) {
                ValidationDelegate d = this.getParent().getDelegate();
                d.setFormComponent(null);
                d.record(this.getMessage("Default_attr_mapping_not_loaded"), ValidationConstraint.REQUIRED);
                this.log.error((Object)(this.getMessage("Default_attr_mapping_not_loaded") + " " + e.getMessage()));
            }
        }
    }

    private void createTasklets(List<IdentityMappingField> identityMapping) {
        this.makeUsernameFieldFirstInMappingList();
        Mode m = this.getMode();
        this.deleteAllTasklets();
        for (IdentityMappingField i : identityMapping) {
            if (i.getFieldInfo().isAttributeGroup()) continue;
            Tasklet t = this.createTasklet(SaaSAttrSingleMappingTasklet.class);
            t.setMode(m);
            t.populate((Object)i);
            this.addTasklet(t);
        }
        this.createAttributeGroupTasklets(m, this.getAllGroupsIdentityMappingFields());
    }

    private Mode getMode() {
        Tasklet p = this.getParent();
        return p.getMode();
    }

    private void createAttributeGroupTasklets(Mode m, List<IdentityMappingField> allGroupsIdentityMappingFields) {
        Map<String, List<String>> attributeGroup = ((SaaSManagementTasklet)((Object)this.findParent(SaaSManagementTasklet.class))).getCustomAttributeGroups();
        for (String attrName : attributeGroup.keySet()) {
            SaaSAttrGroupMappingTasklet t = (SaaSAttrGroupMappingTasklet)this.createTasklet(SaaSAttrGroupMappingTasklet.class);
            t.setAttributeName(attrName);
            t.setAttributeGroupIds(attributeGroup.get(attrName));
            t.setMode(m);
            t.populate(this.getIdentityMappingFieldsPerGroup(attributeGroup.get(attrName), allGroupsIdentityMappingFields));
            this.addTasklet(t);
        }
    }

    private List<IdentityMappingField> getAllGroupsIdentityMappingFields() {
        ArrayList<IdentityMappingField> allGroupsIdentityMappingFields = new ArrayList<IdentityMappingField>();
        for (IdentityMappingField i : this.identityMapping) {
            if (!i.getFieldInfo().isAttributeGroup()) continue;
            allGroupsIdentityMappingFields.add(i);
        }
        return allGroupsIdentityMappingFields;
    }

    private void makeUsernameFieldFirstInMappingList() {
        if (this.userNameFieldCode != null && this.identityMapping != null && this.identityMapping.size() > 0) {
            int userNameFieldIndex = -1;
            for (int idx = 0; idx < this.identityMapping.size(); ++idx) {
                IdentityMappingField field = this.identityMapping.get(idx);
                if (!this.userNameFieldCode.equals(field.getFieldInfo().getCode())) continue;
                userNameFieldIndex = idx;
                break;
            }
            if (userNameFieldIndex > -1) {
                IdentityMappingField field = this.identityMapping.get(userNameFieldIndex);
                this.identityMapping.remove(userNameFieldIndex);
                this.identityMapping.add(0, field);
            }
        }
    }

    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Summary"), "", (TaskletState)this));
    }

    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean failFast) {
        if (this.identityMapping == null || this.identityMapping.isEmpty()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Attr_mapping_required"), ValidationConstraint.REQUIRED);
        } else {
            for (Tasklet tasklet : this.getTasklets()) {
                SaaSAttrMappingTasklet saasAttrTasklet = (SaaSAttrMappingTasklet)tasklet;
                if (saasAttrTasklet.isRequiredAndUndefined()) {
                    delegate.setFormComponent(null);
                    delegate.record(saasAttrTasklet.getFieldLabel() + " " + this.getMessage("Field_required"), ValidationConstraint.REQUIRED);
                }
                if (!saasAttrTasklet.isExpRequiredAndUndefined()) continue;
                delegate.setFormComponent(null);
                delegate.record(saasAttrTasklet.getFieldLabel() + " " + this.getMessage("Expression_required"), ValidationConstraint.REQUIRED);
            }
        }
    }

    public List<IdentityMappingField> getIdentityMapping() {
        return this.identityMapping;
    }

    public void refreshIdentityMappingList(List<IdentityMappingField> updatedIdentityMapping) {
        this.identityMapping = updatedIdentityMapping;
        if (this.getTasklets() != null) {
            this.deleteAllTasklets();
        }
        this.createTasklets(this.identityMapping);
    }

    public boolean isExpressionsEnabled() {
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        return expressionManager.isEvaluateExpressionsOn();
    }

    public List<IdentityMappingField> getIdentityMappingFromTasklets() {
        ArrayList<IdentityMappingField> idMappingFromTasklets = new ArrayList<IdentityMappingField>();
        List taskletList = this.getTasklets();
        if (taskletList != null) {
            for (Tasklet tasklet : taskletList) {
                SaaSAttrMappingTasklet identityMappingTasklet = (SaaSAttrMappingTasklet)tasklet;
                idMappingFromTasklets.addAll(identityMappingTasklet.getIdentityMappingFields());
            }
        }
        return idMappingFromTasklets;
    }

    public List<String> getIdentityMappingFieldNamesFromTasklets() {
        ArrayList<String> idMappingFieldNamesFromTasklets = new ArrayList<String>();
        for (IdentityMappingField mappingField : this.getIdentityMappingFromTasklets()) {
            idMappingFieldNamesFromTasklets.add(mappingField.getFieldName());
        }
        return idMappingFieldNamesFromTasklets;
    }

    private List<IdentityMappingField> getIdentityMappingFieldsPerGroup(List<String> groupIdsPerAttribute, List<IdentityMappingField> allAttributeGroupsIdentityMappingFields) {
        ArrayList<IdentityMappingField> itsOwnIdentityMappingFields = new ArrayList<IdentityMappingField>();
        for (String attrGroupId : groupIdsPerAttribute) {
            for (IdentityMappingField identityMappingField : allAttributeGroupsIdentityMappingFields) {
                if (!identityMappingField.getFieldName().equals(attrGroupId)) continue;
                itsOwnIdentityMappingFields.add(identityMappingField);
            }
        }
        return itsOwnIdentityMappingFields;
    }
}

