/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.SingleTaskletState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.impl.SaaSManagementTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConnectionConfigTasklet;
import com.pingidentity.module.connection.ConnectionModuleConfiguration;
import com.pingidentity.module.connection.admin.ConnectionModuleState;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerConfig;
import com.pingidentity.provisioner.saas.SaasPluginManager;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.SpConnection;

public class SaaSProvisioningState
extends SingleTaskletState
implements ConnectionModuleState {
    private static final long serialVersionUID = 20050515L;
    private static final String NOT_CONFIGURED = "Not Configured";
    private SpConnection spConnection;

    public SaaSProvisioningState(Tasklet value) {
        super((IWizard)value);
        this.setMenuName("Outbound Provisioning");
    }

    public void populate(Object dataFromDisk) {
        if (dataFromDisk instanceof SpConnection) {
            this.spConnection = (SpConnection)dataFromDisk;
            this.onStateActivated();
        }
    }

    public void onStateActivated() {
        ProvisionerConfig provConfig;
        SaaSManagementTasklet t = (SaaSManagementTasklet)this.getTaskletToEdit();
        if (this.spConnection == null) {
            this.spConnection = new SpConnection();
            provConfig = new ProvisionerConfig();
            provConfig.setType(this.getSelectedPluginId());
            this.spConnection.addConnectionModuleConfiguration((ConnectionModuleConfiguration)provConfig);
        } else {
            provConfig = (ProvisionerConfig)this.spConnection.getModuleConfiguration(ProvisionerConfig.class);
            if (provConfig.getType() == null) {
                String pluginId = this.getSelectedPluginId();
                provConfig.setType(pluginId);
            }
        }
        if (t == null) {
            t = (SaaSManagementTasklet)this.createTaskletToLoad(SaaSManagementTasklet.class);
            t.setFinishAvailable(this.isAuthorizedForAction());
            t.markProtocolImgAvailable(true);
            Tasklet p = (Tasklet)this.getParent(SpConnectionConfigTasklet.class);
            t.setMode(p.getMode());
            t.setFinishLabel("Done");
            if (this.isRequiredPluginLoaded()) {
                t.reconfigureTransitions(this.getSelectedPluginId());
                t.populate(this.spConnection);
            }
            this.setTasklet(t);
        } else {
            String configuredPluginId = t.getPluginId();
            String selectedPluginId = this.getSelectedPluginId();
            if (configuredPluginId != null && !configuredPluginId.equals(selectedPluginId)) {
                Iterator it = this.spConnection.getConnectionModuleConfigurations().iterator();
                while (it.hasNext()) {
                    ConnectionModuleConfiguration moduleConfig = (ConnectionModuleConfiguration)it.next();
                    if (!(moduleConfig instanceof ProvisionerConfig)) continue;
                    it.remove();
                    break;
                }
                ProvisionerConfig newProvConfig = new ProvisionerConfig();
                newProvConfig.setType(selectedPluginId);
                this.spConnection.addConnectionModuleConfiguration((ConnectionModuleConfiguration)newProvConfig);
                t.reconfigureTransitions(this.getSelectedPluginId());
                t.populate(this.spConnection);
            }
        }
    }

    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (!this.isRequiredPluginLoaded()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Required_plugin_not_loaded"), ValidationConstraint.REQUIRED);
        } else {
            SaaSManagementTasklet t = (SaaSManagementTasklet)this.getTasklet();
            t.appendErrors(delegate, component, fastFail);
            if (delegate.getHasErrors()) {
                delegate.clear();
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Saas_provisioning_not_configured"), ValidationConstraint.REQUIRED);
            }
        }
    }

    public void manageSaaSChannels(IRequestCycle cycle) {
        SaaSManagementTasklet t = (SaaSManagementTasklet)this.getTaskletToEdit();
        t.resetCurrentStateToSourceState();
        this.loadTasklet(t);
        t.setTriggerAppendErrors();
        if (t.isTargetSet()) {
            t.gotoSummaryState(cycle);
        } else {
            t.setSaaSManagementAsNotClickable();
        }
    }

    public String getPluginDescription() {
        String pluginId = this.getSelectedPluginId();
        String pluginDesc = SaasPluginManager.getInstance().getPluginDescription(pluginId);
        return pluginDesc == null ? "" : pluginDesc;
    }

    public String getSourceRepository() {
        String repositories = NOT_CONFIGURED;
        if (!this.isRequiredPluginLoaded()) {
            repositories = "";
        } else {
            SaaSManagementTasklet saasManagementTasklet = (SaaSManagementTasklet)this.getTaskletToEdit();
            String sources = saasManagementTasklet.getChannelSourcesForSummary();
            if (!StringUtils.isEmpty((String)sources)) {
                repositories = sources;
            }
        }
        return repositories;
    }

    public boolean isRequiredPluginLoaded() {
        ProvisionerConfig provConfig = (ProvisionerConfig)this.spConnection.getModuleConfiguration(ProvisionerConfig.class);
        if (provConfig == null) {
            return false;
        }
        String pluginId = provConfig.getType();
        return SaasPluginManager.getInstance().getPluginInstance(pluginId) != null;
    }

    public String getSelectedPluginId() {
        SpConnectionConfigTasklet t = (SpConnectionConfigTasklet)this.getParent();
        return t.getSelectedConnectionModuleType(((Object)((Object)this)).getClass());
    }

    public void resetForNewConnection() {
        this.spConnection = null;
        this.setTaskletToEditToNull();
    }
}

