/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.ConfigLdapDirSearchState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.impl.SaaSAttrGroupMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.SaaSChannelTasklet;
import com.pingidentity.fsm.tasklet.impl.SaaSManagementTasklet;
import com.pingidentity.provisioner.domain.Channel;
import com.pingidentity.provisioner.domain.IdentityMappingField;
import com.pingidentity.provisioner.mapping.FieldConfig;
import com.pingidentity.provisioner.mapping.FieldInfo;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.saml20.domain.LdapDataSource;

public class SaaSSelectAttrGroupMappingState
extends ConfigLdapDirSearchState {
    List<IdentityMappingField> attributeMappings = new ArrayList<IdentityMappingField>();
    transient StringPairPropertySelectionModel unmappedAttrGroupIds;
    String selectedAttrGroupId;
    private boolean editMode;
    private boolean createOnly = false;
    private boolean trim = false;
    private boolean mask = false;
    private String defaultValue = "";
    private IdentityMappingField.FIELD_CASE fieldCase = noCase;
    private static IdentityMappingField.FIELD_CASE upperCase = IdentityMappingField.FIELD_CASE.UPPER;
    private static IdentityMappingField.FIELD_CASE lowerCase = IdentityMappingField.FIELD_CASE.LOWER;
    private static IdentityMappingField.FIELD_CASE noCase = IdentityMappingField.FIELD_CASE.NONE;
    private IdentityMappingField.TRANSFORM_OPTION transformOptionSelection = IdentityMappingField.TRANSFORM_OPTION.NONE;

    public SaaSSelectAttrGroupMappingState(Tasklet value) {
        super(value);
        this.setMenuName("Specify Attribute Mapping");
    }

    public void populate(Object dataFromDisk) {
        this.attributeMappings = this.getCopyOfAttrMappings((List)dataFromDisk);
        SaaSChannelTasklet tasklet = (SaaSChannelTasklet)((Object)this.findParent(SaaSChannelTasklet.class));
        this.dataSource = (LdapDataSource)tasklet.getSelectedDataSource();
        this.populate();
    }

    public List<IdentityMappingField> getCopyOfAttrMappings(List<IdentityMappingField> identityMappingFieldList) {
        ArrayList<IdentityMappingField> copyList = new ArrayList<IdentityMappingField>();
        for (IdentityMappingField mappingField : identityMappingFieldList) {
            FieldConfig copyFieldConfig = new FieldConfig();
            ArrayList selectedAttributesCopy = new ArrayList(mappingField.getFieldConfig().getAttributeNames());
            copyFieldConfig.addAttributeNames(selectedAttributesCopy);
            copyFieldConfig.setCreateOnly(mappingField.getFieldConfig().isCreateOnly());
            copyFieldConfig.setTrim(mappingField.getFieldConfig().isTrim());
            copyFieldConfig.setMasked(mappingField.getFieldConfig().isMasked());
            copyFieldConfig.setToLower(mappingField.getFieldConfig().isToLower());
            copyFieldConfig.setToUpper(mappingField.getFieldConfig().isToUpper());
            copyFieldConfig.setExtractCnFromDn(mappingField.getFieldConfig().isExtractCnFromDn());
            copyFieldConfig.setExtractUserNameFromEmail(mappingField.getFieldConfig().isExtractUserNameFromEmail());
            copyFieldConfig.setDefault(mappingField.getFieldConfig().getDefault());
            IdentityMappingField copyIdentityMappingField = new IdentityMappingField(mappingField.getFieldName());
            copyIdentityMappingField.setFieldConfig(copyFieldConfig);
            copyIdentityMappingField.setFieldInfo(mappingField.getFieldInfo());
            copyList.add(copyIdentityMappingField);
        }
        return copyList;
    }

    public void populate() {
        if (!this.isViewOnly() && this.dataSource != null) {
            this.initializeSearchScope();
            this.selectedRootClass = "";
            this.availableAttributes = this.getAvailableAttrs();
            this.selectedAttributes = new ArrayList();
            this.availableAttrList = this.createPairModel(this.availableAttributes);
            this.selectedAttrGroupId = "";
            this.selectedAvailableAttr = "";
            this.unmappedAttrGroupIds = this.calculateUnmappedAttrGroupIds();
        }
        if (StringUtils.isBlank((String)this.selectedAvailableAttr)) {
            this.selectedAvailableAttr = null;
        }
    }

    public boolean save(Object dataToDisk) {
        if (dataToDisk instanceof Channel) {
            Channel channel = (Channel)dataToDisk;
            channel.getIdentityMapping().addAll(this.getCopyOfAttrMappings(this.attributeMappings));
        } else {
            ((List)dataToDisk).addAll(this.getCopyOfAttrMappings(this.attributeMappings));
        }
        return true;
    }

    public void onStateActivated() {
        SaaSChannelTasklet grandParentTasklet = (SaaSChannelTasklet)((Object)this.findParent(SaaSChannelTasklet.class));
        SaaSAttrGroupMappingTasklet parentTasklet = (SaaSAttrGroupMappingTasklet)((Object)this.findParent(SaaSAttrGroupMappingTasklet.class));
        SaaSSelectAttrGroupMappingState saaSSelectAttrGroupMappingState = (SaaSSelectAttrGroupMappingState)parentTasklet.getCurrentState();
        if (grandParentTasklet != null && grandParentTasklet.getSelectedDataSource() != null) {
            LdapDataSource temp = (LdapDataSource)grandParentTasklet.getSelectedDataSource();
            super.initDataSource(temp);
        }
        if (this.attributeMappings == null) {
            this.attributeMappings = saaSSelectAttrGroupMappingState.getAttributeMappings();
        }
        if (this.unmappedAttrGroupIds == null) {
            this.unmappedAttrGroupIds = this.calculateUnmappedAttrGroupIds();
        }
        if (this.searchScopeList == null) {
            this.searchScopeList = new StringPairPropertySelectionModel();
        }
        if (this.rootObjClassList == null) {
            this.rootObjClassList = new StringPairPropertySelectionModel();
        }
        if (this.availableAttrList == null) {
            this.availableAttrList = new StringPairPropertySelectionModel();
        }
        this.editMode = false;
    }

    public void addMapping() {
        if (this.passedValidation()) {
            this.attributeMappings.add(this.createIdentityMappingField());
            this.selectedAttrGroupId = "";
            this.selectedAvailableAttr = "";
        }
    }

    private boolean passedValidation() {
        ValidationDelegate delegate = this.getParent().getDelegate();
        this.validateMappingSettings(delegate);
        return !delegate.getHasErrors();
    }

    private void validateMappingSettings(ValidationDelegate delegate) {
        if (this.selectedAttrGroupId == null || StringUtils.isWhitespace((String)this.selectedAttrGroupId)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("group_attribute_id_required"), ValidationConstraint.REQUIRED);
        }
    }

    public void deleteMapping(String fieldNameToDelete) {
        IdentityMappingField mappingFieldToBeDeleted = new IdentityMappingField(fieldNameToDelete);
        for (IdentityMappingField attributeMapping : this.attributeMappings) {
            if (!attributeMapping.getFieldName().equals(fieldNameToDelete)) continue;
            mappingFieldToBeDeleted = attributeMapping;
        }
        this.attributeMappings.remove(mappingFieldToBeDeleted);
        this.unmappedAttrGroupIds.add(fieldNameToDelete, (Object)fieldNameToDelete);
    }

    private List<String> getAllAttributeGroupIds() {
        return ((SaaSAttrGroupMappingTasklet)this.getParent()).getAttributeGroupIds();
    }

    public StringPairPropertySelectionModel calculateUnmappedAttrGroupIds() {
        ArrayList<String> mappedAttributeIds = new ArrayList<String>();
        for (IdentityMappingField identityMappingField : this.attributeMappings) {
            mappedAttributeIds.add(identityMappingField.getFieldName());
        }
        ArrayList<String> unmappedAttrIds = new ArrayList<String>();
        unmappedAttrIds.addAll(this.getAllAttributeGroupIds());
        unmappedAttrIds.removeAll(mappedAttributeIds);
        return this.createPairModel(unmappedAttrIds);
    }

    protected StringPairPropertySelectionModel createPairModel(List<String> l) {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel();
        for (String value : l) {
            model.add(value, (Object)value);
        }
        return model;
    }

    public IdentityMappingField createIdentityMappingField() {
        FieldConfig fieldConfig = new FieldConfig();
        fieldConfig.addAttributeNames(this.selectedAvailableAttr);
        fieldConfig.setCreateOnly(this.createOnly);
        fieldConfig.setTrim(this.trim);
        fieldConfig.setMasked(this.mask);
        if (this.fieldCase.equals((Object)IdentityMappingField.FIELD_CASE.LOWER)) {
            fieldConfig.setToLower(true);
            fieldConfig.setToUpper(false);
        } else if (this.fieldCase.equals((Object)IdentityMappingField.FIELD_CASE.UPPER)) {
            fieldConfig.setToLower(false);
            fieldConfig.setToUpper(true);
        } else {
            fieldConfig.setToLower(false);
            fieldConfig.setToUpper(false);
        }
        if (IdentityMappingField.TRANSFORM_OPTION.EXTRACT_CN_FROM_DN.equals((Object)this.transformOptionSelection)) {
            fieldConfig.setExtractCnFromDn(true);
        } else if (IdentityMappingField.TRANSFORM_OPTION.EXTRACT_USERNAME_FROM_EMAIL.equals((Object)this.transformOptionSelection)) {
            fieldConfig.setExtractUserNameFromEmail(true);
        }
        fieldConfig.setDefault(this.defaultValue);
        IdentityMappingField identityMappingField = new IdentityMappingField(this.selectedAttrGroupId);
        identityMappingField.setFieldConfig(fieldConfig);
        FieldInfo fieldInfo = new FieldInfo(this.selectedAttrGroupId, this.selectedAttrGroupId);
        fieldInfo.setAttributeGroup(true);
        fieldInfo.setMultiValue(this.isAttributeMultivalued());
        identityMappingField.setFieldInfo(fieldInfo);
        this.unmappedAttrGroupIds.remove(this.selectedAttrGroupId);
        this.createOnly = false;
        this.trim = false;
        this.mask = false;
        this.fieldCase = noCase;
        this.transformOptionSelection = IdentityMappingField.TRANSFORM_OPTION.NONE;
        this.defaultValue = "";
        return identityMappingField;
    }

    private boolean isAttributeMultivalued() {
        String attrName = ((SaaSAttrGroupMappingTasklet)this.getParent()).getAttributeName();
        SaaSManagementTasklet saaSManagementTasklet = (SaaSManagementTasklet)((Object)this.findParent(SaaSManagementTasklet.class));
        Map<String, Boolean> attributeName_MultivalueSetting_Map = saaSManagementTasklet.getCustomAttributeNamesAndTheirMultivaluedSettings();
        for (String customAttributeName : attributeName_MultivalueSetting_Map.keySet()) {
            if (!attrName.equalsIgnoreCase(customAttributeName)) continue;
            return attributeName_MultivalueSetting_Map.get(customAttributeName);
        }
        return false;
    }

    public boolean isDisplayListOfMappingsLabel() {
        return this.attributeMappings.size() > 0;
    }

    public boolean isDisplayAttributeAddMappingUI() {
        return this.unmappedAttrGroupIds != null && this.unmappedAttrGroupIds.getOptionCount() == 0;
    }

    public StringPairPropertySelectionModel getUnmappedAttrGroupIds() {
        return this.unmappedAttrGroupIds;
    }

    public void setUnmappedAttrGroupIds(StringPairPropertySelectionModel unmappedAttrGroupIds) {
        this.unmappedAttrGroupIds = unmappedAttrGroupIds;
    }

    public String getSelectedAttrGroupId() {
        return this.selectedAttrGroupId;
    }

    public void setSelectedAttrGroupId(String selectedAttrGroupId) {
        this.selectedAttrGroupId = selectedAttrGroupId;
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
    }

    public boolean isCreateOnly() {
        return this.createOnly;
    }

    public void setCreateOnly(boolean createOnly) {
        this.createOnly = createOnly;
    }

    public boolean isTrim() {
        return this.trim;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    public boolean isMask() {
        return this.mask;
    }

    public void setMask(boolean mask) {
        this.mask = mask;
    }

    public IdentityMappingField.FIELD_CASE getFieldCase() {
        return this.fieldCase;
    }

    public void setFieldCase(IdentityMappingField.FIELD_CASE fieldCase) {
        this.fieldCase = fieldCase;
    }

    public static IdentityMappingField.FIELD_CASE getUpperCase() {
        return upperCase;
    }

    public static void setUpperCase(IdentityMappingField.FIELD_CASE upperCase) {
        SaaSSelectAttrGroupMappingState.upperCase = upperCase;
    }

    public static IdentityMappingField.FIELD_CASE getLowerCase() {
        return lowerCase;
    }

    public static void setLowerCase(IdentityMappingField.FIELD_CASE lowerCase) {
        SaaSSelectAttrGroupMappingState.lowerCase = lowerCase;
    }

    public static IdentityMappingField.FIELD_CASE getNoCase() {
        return noCase;
    }

    public static void setNoCase(IdentityMappingField.FIELD_CASE noCase) {
        SaaSSelectAttrGroupMappingState.noCase = noCase;
    }

    public IdentityMappingField.TRANSFORM_OPTION getExtractCnFromDn() {
        return IdentityMappingField.TRANSFORM_OPTION.EXTRACT_CN_FROM_DN;
    }

    public IdentityMappingField.TRANSFORM_OPTION getExtractEmail() {
        return IdentityMappingField.TRANSFORM_OPTION.EXTRACT_USERNAME_FROM_EMAIL;
    }

    public IdentityMappingField.TRANSFORM_OPTION getTransformOptionSelection() {
        return this.transformOptionSelection;
    }

    public void setTransformOptionSelection(IdentityMappingField.TRANSFORM_OPTION transformOptionSelection) {
        this.transformOptionSelection = transformOptionSelection;
    }

    public StringPairPropertySelectionModel getTransformOptionsList() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel();
        model.add("None", (Object)IdentityMappingField.TRANSFORM_OPTION.NONE);
        model.add("Extract CN from DN", (Object)IdentityMappingField.TRANSFORM_OPTION.EXTRACT_CN_FROM_DN);
        model.add("Extract Username from Email", (Object)IdentityMappingField.TRANSFORM_OPTION.EXTRACT_USERNAME_FROM_EMAIL);
        return model;
    }

    public List<IdentityMappingField> getAttributeMappings() {
        return this.attributeMappings;
    }

    public List<IdentityMappingField> getAttributeMappingsCopy() {
        List<IdentityMappingField> attributeMappingsCopy = this.attributeMappings.stream().collect(Collectors.toList());
        return attributeMappingsCopy;
    }

    public void setAttributeMappings(List<IdentityMappingField> attributeMappings) {
        this.attributeMappings = attributeMappings;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    protected boolean isAttributeOptionsSupported() {
        return false;
    }
}

