/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.common.util.ldap.LDAPUtil;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.SaaSProvisioningState;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.SaaSChannelTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConnectionConfigTasklet;
import com.pingidentity.provisioner.domain.Channel;
import com.pingidentity.provisioner.domain.source.ChannelSource;
import com.pingidentity.provisioner.saas.SaasPluginManager;
import com.pingidentity.provisioner.saas.SaasProvisionerPlugin;
import com.pingidentity.provisioner.saas.SaasProvisionerPluginGroupsExtension;
import com.pingidentity.provisioner.saas.SaasProvisionerPluginGroupsWithMembersExt;
import java.util.ArrayList;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;

public class SaaSSourceLocationState
extends TaskletState {
    private static final long serialVersionUID = 2L;
    private String userBaseDn = "";
    private String filterForUsers = "";
    private String groupDnForUsers = "";
    private String groupDnForGroups = "";
    private String groupFilterForGroups = "";
    private boolean userNestedSearch;
    private boolean groupNestedSearch;

    public SaaSSourceLocationState(IWizard owner) {
        super(owner);
        this.setMenuName("Source Location");
    }

    public void populate(Object dataFromDisk) {
        if (dataFromDisk instanceof Channel) {
            Channel c = (Channel)dataFromDisk;
            ChannelSource s = c.getSource();
            this.userBaseDn = s.getUserBaseDN();
            this.groupDnForUsers = s.getGroupDNForUsers();
            this.filterForUsers = s.getFilterForUsers();
            this.groupDnForGroups = s.getGroupDNForGroups();
            this.groupFilterForGroups = s.getGroupFilterForGroups();
            this.userNestedSearch = s.isUserNestedSearch();
            this.groupNestedSearch = s.isGroupNestedSearch();
        }
    }

    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (StringUtils.isEmpty((String)this.userBaseDn)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("User_base_dn_required"), ValidationConstraint.REQUIRED);
        } else {
            try {
                new LdapName(this.userBaseDn);
            }
            catch (InvalidNameException e) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Invalid_base_dn"), ValidationConstraint.REQUIRED);
            }
        }
        if (StringUtils.isEmpty((String)this.filterForUsers) && StringUtils.isEmpty((String)this.groupDnForUsers)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("User_filter_or_groupdn_required"), ValidationConstraint.REQUIRED);
        }
        if (StringUtils.isNotEmpty((String)this.filterForUsers) && !LDAPUtil.validateFilter((String)this.filterForUsers)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Invalid_user_filter"), ValidationConstraint.REQUIRED);
        }
        if (StringUtils.isNotEmpty((String)this.groupFilterForGroups) && !LDAPUtil.validateFilter((String)this.groupFilterForGroups)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Invalid_groupdn_filter"), ValidationConstraint.REQUIRED);
        }
        if (!StringUtils.isEmpty((String)this.groupDnForUsers)) {
            try {
                new LdapName(this.groupDnForUsers);
            }
            catch (InvalidNameException e) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Invalid_group_dn"), ValidationConstraint.REQUIRED);
            }
            if (this.groupDnForUsers != null && StringUtils.startsWithIgnoreCase((String)this.groupDnForUsers, (String)"ou=")) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Invalid_users_group_dn_expect_group_object"), ValidationConstraint.CONSISTENCY);
            }
        }
        if (!StringUtils.isEmpty((String)this.groupDnForGroups)) {
            try {
                new LdapName(this.groupDnForGroups);
            }
            catch (InvalidNameException e) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Invalid_group_dn_for_groups"), ValidationConstraint.REQUIRED);
            }
            if (this.groupDnForGroups != null && StringUtils.startsWithIgnoreCase((String)this.groupDnForGroups, (String)"ou=")) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Invalid_groups_group_dn_expect_group_object"), ValidationConstraint.CONSISTENCY);
            }
        }
    }

    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Base DN", this.userBaseDn, (TaskletState)this));
        if (!StringUtils.isBlank((String)this.groupDnForUsers)) {
            summaryList.add(new SummaryInfo("Group DN for Users", this.groupDnForUsers, (TaskletState)this));
            summaryList.add(new SummaryInfo("User Nested Search", String.valueOf(this.userNestedSearch), (TaskletState)this));
        }
        if (!StringUtils.isBlank((String)this.filterForUsers)) {
            summaryList.add(new SummaryInfo("Filter for Users", this.filterForUsers, (TaskletState)this));
        }
        if (!StringUtils.isBlank((String)this.groupDnForGroups)) {
            summaryList.add(new SummaryInfo("Group DN for Groups", this.groupDnForGroups, (TaskletState)this));
            summaryList.add(new SummaryInfo("Group Nested Search", String.valueOf(this.groupNestedSearch), (TaskletState)this));
        }
        if (!StringUtils.isBlank((String)this.groupFilterForGroups)) {
            summaryList.add(new SummaryInfo("Group Filter for Groups", this.groupFilterForGroups, (TaskletState)this));
        }
    }

    public boolean save(Object dataToDisk) {
        Channel channel = (Channel)dataToDisk;
        channel.getSource().setUserBaseDN(this.userBaseDn);
        channel.getSource().setGroupDNForUsers(this.groupDnForUsers);
        channel.getSource().setFilterForUsers(this.filterForUsers);
        channel.getSource().setGroupDNForGroups(this.groupDnForGroups);
        channel.getSource().setGroupFilterForGroups(this.groupFilterForGroups);
        channel.getSource().setUserNestedSearch(this.showNestedSearch() && StringUtils.isNotBlank((String)this.groupDnForUsers) ? this.userNestedSearch : false);
        channel.getSource().setGroupNestedSearch(this.showNestedSearch() && StringUtils.isNotBlank((String)this.groupDnForGroups) ? this.groupNestedSearch : false);
        return true;
    }

    public String getUserBaseDn() {
        return this.userBaseDn;
    }

    public void setUserBaseDn(String userBaseDn) {
        this.userBaseDn = userBaseDn;
    }

    public String getGroupDnForUsers() {
        return this.groupDnForUsers;
    }

    public void setGroupDnForUsers(String groupDnForUsers) {
        this.groupDnForUsers = groupDnForUsers;
    }

    public String getFilterForUsers() {
        return this.filterForUsers;
    }

    public void setFilterForUsers(String filterForUsers) {
        this.filterForUsers = filterForUsers;
    }

    public String getGroupDnForGroups() {
        return this.groupDnForGroups;
    }

    public void setGroupDnForGroups(String groupDnForGroups) {
        this.groupDnForGroups = groupDnForGroups;
    }

    public String getGroupFilterForGroups() {
        return this.groupFilterForGroups;
    }

    public void setGroupFilterForGroups(String groupFilterForGroups) {
        this.groupFilterForGroups = groupFilterForGroups;
    }

    public boolean isGroupProvisioningSupported() {
        SpConnectionConfigTasklet spConnectionConfigTasklet = (SpConnectionConfigTasklet)this.findParent(SpConnectionConfigTasklet.class);
        String pluginId = spConnectionConfigTasklet.getSelectedConnectionModuleType(SaaSProvisioningState.class);
        SaasPluginManager pluginManager = SaasPluginManager.getInstance();
        SaasProvisionerPlugin pluginInstance = pluginManager.getPluginInstance(pluginId);
        return pluginInstance instanceof SaasProvisionerPluginGroupsExtension || pluginInstance instanceof SaasProvisionerPluginGroupsWithMembersExt;
    }

    public boolean isUserNestedSearch() {
        return this.userNestedSearch;
    }

    public void setUserNestedSearch(boolean userNestedSearch) {
        this.userNestedSearch = userNestedSearch;
    }

    public boolean showNestedSearch() {
        SaaSChannelTasklet saasChannelTasklet = (SaaSChannelTasklet)this.getParent();
        String ldapType = saasChannelTasklet.getSelectedLdapType();
        return LdapInfo.LdapType.ActiveDirectory.name().equals(ldapType) || LdapInfo.LdapType.SunDirectoryServer.name().equals(ldapType) || LdapInfo.LdapType.OracleUnifiedDirectory.name().equals(ldapType) || LdapInfo.LdapType.PingDirectory.name().equals(ldapType) || LdapInfo.LdapType.PingDS.name().equals(ldapType);
    }

    public boolean isGroupNestedSearch() {
        return this.groupNestedSearch;
    }

    public void setGroupNestedSearch(boolean groupNestedSearch) {
        this.groupNestedSearch = groupNestedSearch;
    }
}

