/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.SaaSChannelTasklet;
import com.pingidentity.provisioner.domain.Channel;
import com.pingidentity.provisioner.domain.source.ChannelSource;
import com.pingidentity.templates.mgmt.SaaSLdapTemplateFileManager;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class SaaSSourceSettingsState
extends TaskletState {
    private static final long serialVersionUID = 2L;
    private static final String[] trueFalseArray = new String[]{"true", "false"};
    private static final String GUID_TYPE_TEXT = "Text";
    private static final String GUID_TYPE_BINARY = "Binary";
    private static final String[] guidTypeArray = new String[]{"Text", "Binary"};
    private StringPairPropertySelectionModel trueFalseModel = new StringPairPropertySelectionModel(false, trueFalseArray);
    private String entryGuidAttr = null;
    private String selectedGuidType = null;
    private String memberOfGroupAttr = null;
    private String groupMemberAttr = null;
    private String userObjectClass = null;
    private String groupObjectClass = null;
    private String selectedChangedUsersAlgorithm = null;
    private StringPairPropertySelectionModel changedUsersAlgorithmList = new StringPairPropertySelectionModel(false);
    private String timestampAttr = null;
    private String usnAttr = null;
    private String acctStatusAttr = null;
    private String flagComparisonValue = null;
    private String selectedAcctStatusAlgorithm = null;
    private StringPairPropertySelectionModel acctStatusAlgorithmList = new StringPairPropertySelectionModel(false);
    private String selectedFlagComparisonStatus = null;
    private String selectedDefaultStatus = null;
    private String sourceId = null;
    private StringPairPropertySelectionModel guidTypeList = new StringPairPropertySelectionModel(false, guidTypeArray);

    public SaaSSourceSettingsState(IWizard owner) {
        super(owner);
        this.setMenuName("Source Settings");
    }

    public void populate(Object dataFromDisk) {
        if (dataFromDisk instanceof Channel) {
            Channel channel = (Channel)dataFromDisk;
            this.populateSettings(channel.getSource());
        }
    }

    private void populateSettings(ChannelSource channelSource) {
        this.entryGuidAttr = channelSource.getGuidFormatter().getGuidAttributeName();
        this.selectedGuidType = channelSource.getGuidFormatter().isGuidIsBinary() ? GUID_TYPE_BINARY : GUID_TYPE_TEXT;
        this.memberOfGroupAttr = channelSource.getMemberOfGroupAttributeName();
        this.groupMemberAttr = channelSource.getGroupMemberAttributeName();
        this.userObjectClass = channelSource.getUserObjectClass();
        this.groupObjectClass = channelSource.getGroupObjectClass();
        this.selectedChangedUsersAlgorithm = channelSource.getChangedUsersAlgorithm();
        this.timestampAttr = channelSource.getTimeStampAttributeName();
        this.usnAttr = channelSource.getUsnAttributeName();
        this.acctStatusAttr = channelSource.getAccountStatusAttributeName();
        this.selectedAcctStatusAlgorithm = channelSource.getAccountStatusAlgorithm();
        this.flagComparisonValue = channelSource.getFlagComparisonValue();
        this.selectedFlagComparisonStatus = Boolean.toString(channelSource.isFlagComparisonStatus());
        this.selectedDefaultStatus = Boolean.toString(channelSource.isDefaultStatus());
    }

    public boolean save(Object dataToDisk) {
        Channel channel = (Channel)dataToDisk;
        ChannelSource channelSource = channel.getSource();
        channelSource.getGuidFormatter().setGuidAttributeName(this.entryGuidAttr);
        boolean guidIsBinary = this.selectedGuidType.equals(GUID_TYPE_BINARY);
        channelSource.getGuidFormatter().setGuidIsBinary(guidIsBinary);
        channelSource.setMemberOfGroupAttributeName(this.memberOfGroupAttr);
        channelSource.setGroupMemberAttributeName(this.groupMemberAttr);
        channelSource.setUserObjectClass(this.userObjectClass);
        channelSource.setGroupObjectClass(this.groupObjectClass);
        channelSource.setChangedUsersAlgorithm(this.selectedChangedUsersAlgorithm);
        channelSource.setTimeStampAttributeName(this.timestampAttr);
        channelSource.setUsnAttributeName(this.usnAttr);
        channelSource.setAccountStatusAttributeName(this.acctStatusAttr);
        channelSource.setAccountStatusAlgorithm(this.selectedAcctStatusAlgorithm);
        channelSource.setFlagComparisonValue(this.flagComparisonValue);
        channelSource.setFlagComparisonStatus(Boolean.parseBoolean(this.selectedFlagComparisonStatus));
        channelSource.setDefaultStatus(Boolean.parseBoolean(this.selectedDefaultStatus));
        return true;
    }

    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean failFast) {
        if (StringUtils.isBlank((String)this.entryGuidAttr)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Entry_guid_attr_required"), ValidationConstraint.REQUIRED);
        }
        if (this.isActiveDirectory() && StringUtils.isBlank((String)this.memberOfGroupAttr)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Member_of_group_attr_required"), ValidationConstraint.REQUIRED);
        } else if (StringUtils.isBlank((String)this.memberOfGroupAttr) && StringUtils.isBlank((String)this.groupMemberAttr)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Group_member_attr_or_member_of_group_attr_required"), ValidationConstraint.REQUIRED);
        }
        if (StringUtils.isBlank((String)this.userObjectClass)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("User_object_class_required"), ValidationConstraint.REQUIRED);
        }
        if (StringUtils.isBlank((String)this.groupObjectClass)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Group_object_class_required"), ValidationConstraint.REQUIRED);
        }
        if ("Active Directory USN".equals(this.selectedChangedUsersAlgorithm) && StringUtils.isBlank((String)this.usnAttr)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Usn_attr_required"), ValidationConstraint.REQUIRED);
        }
        if (StringUtils.isBlank((String)this.timestampAttr)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Timestamp_attr_required"), ValidationConstraint.REQUIRED);
        }
        if (StringUtils.isBlank((String)this.acctStatusAttr)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Acct_status_attr_required"), ValidationConstraint.REQUIRED);
        }
        if ("Flag".equals(this.selectedAcctStatusAlgorithm) && StringUtils.isBlank((String)this.flagComparisonValue)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Flag_comparison_value_required"), ValidationConstraint.REQUIRED);
        }
    }

    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Entry GUID Attribute", this.entryGuidAttr, (TaskletState)this));
        summaryList.add(new SummaryInfo("GUID Type", this.selectedGuidType, (TaskletState)this));
        summaryList.add(new SummaryInfo("Member of Group Attribute", this.memberOfGroupAttr, (TaskletState)this));
        summaryList.add(new SummaryInfo("Group Member Attribute", this.groupMemberAttr, (TaskletState)this));
        summaryList.add(new SummaryInfo("User objectClass", this.userObjectClass, (TaskletState)this));
        summaryList.add(new SummaryInfo("Group objectClass", this.groupObjectClass, (TaskletState)this));
        summaryList.add(new SummaryInfo("Changed Users Algorithm", this.selectedChangedUsersAlgorithm, (TaskletState)this));
        if (!this.isUsnAttrDisabled()) {
            summaryList.add(new SummaryInfo("USN Attribute", this.usnAttr, (TaskletState)this));
        }
        summaryList.add(new SummaryInfo("Timestamp Attribute", this.timestampAttr, (TaskletState)this));
        summaryList.add(new SummaryInfo("Account Status Attribute", this.acctStatusAttr, (TaskletState)this));
        summaryList.add(new SummaryInfo("Account Status Algorithm", this.selectedAcctStatusAlgorithm, (TaskletState)this));
        summaryList.add(new SummaryInfo("Default Status", this.selectedDefaultStatus, (TaskletState)this));
        if (!this.isFlagComparisonValueDisabled()) {
            summaryList.add(new SummaryInfo("Flag Comparison Value", this.flagComparisonValue, (TaskletState)this));
        }
        if (!this.isFlagComparisonStatusDisabled()) {
            summaryList.add(new SummaryInfo("Flag Comparison Status", this.selectedFlagComparisonStatus, (TaskletState)this));
        }
    }

    public void onResumeDraft() {
        DataSourceManager dataMgr = MgmtFactory.getDataSourceManager();
        LdapDataSource source = dataMgr.getLdapDataSource(this.sourceId);
        if (source != null) {
            String ldapTypeStr = source.getLdapType().name();
            this.changedUsersAlgorithmList = new StringPairPropertySelectionModel(false, ChannelSource.getChangedUsersAlgorithmList((String)ldapTypeStr));
            this.acctStatusAlgorithmList = new StringPairPropertySelectionModel(false, ChannelSource.getAccountStatusAlgorithmList((String)ldapTypeStr));
        } else {
            this.changedUsersAlgorithmList = new StringPairPropertySelectionModel(false);
            this.acctStatusAlgorithmList = new StringPairPropertySelectionModel(false);
        }
        this.trueFalseModel = new StringPairPropertySelectionModel(false, trueFalseArray);
        this.guidTypeList = new StringPairPropertySelectionModel(false, guidTypeArray);
    }

    public void onStateActivated() {
        DataSourceManager dataMgr;
        LdapDataSource source;
        SaaSChannelTasklet t = (SaaSChannelTasklet)this.getParent();
        if (t != null && t.getSelectedDataSource() != null) {
            this.sourceId = t.getSelectedDataSource().getId();
        }
        if ((source = (dataMgr = MgmtFactory.getDataSourceManager()).getLdapDataSource(this.sourceId)) != null) {
            SaaSLdapTemplateFileManager templateMgr;
            Properties properties;
            String ldapTypeStr = source.getLdapType().name();
            this.changedUsersAlgorithmList = new StringPairPropertySelectionModel(false, ChannelSource.getChangedUsersAlgorithmList((String)ldapTypeStr));
            this.acctStatusAlgorithmList = new StringPairPropertySelectionModel(false, ChannelSource.getAccountStatusAlgorithmList((String)ldapTypeStr));
            if (t.isSourceSelectionStateChanged() && (properties = (templateMgr = SaaSLdapTemplateFileManager.getInstance()).getSaaSLdapTemplateProperties(source.getLdapTypeDesc())) != null) {
                ChannelSource defaultSourceSettings = ChannelSource.Factory.newInstance((Properties)properties);
                this.populateSettings(defaultSourceSettings);
                t.setSourceSelectionStateChanged(false);
            }
        }
        this.guidTypeList = new StringPairPropertySelectionModel(false, guidTypeArray);
        if (!this.isActiveDirectory()) {
            this.selectedAcctStatusAlgorithm = "Flag";
        }
    }

    public StringPairPropertySelectionModel getChangedUsersAlgorithmList() {
        return this.changedUsersAlgorithmList;
    }

    public StringPairPropertySelectionModel getAcctStatusAlgorithmList() {
        return this.acctStatusAlgorithmList;
    }

    public String getEntryGuidAttr() {
        return this.entryGuidAttr;
    }

    public void setEntryGuidAttr(String entryGuidAttr) {
        this.entryGuidAttr = entryGuidAttr;
    }

    public String getMemberOfGroupAttr() {
        return this.memberOfGroupAttr;
    }

    public void setMemberOfGroupAttr(String memberOfGroupAttr) {
        this.memberOfGroupAttr = memberOfGroupAttr;
    }

    public String getGroupMemberAttr() {
        return this.groupMemberAttr;
    }

    public void setGroupMemberAttr(String groupMemberAttr) {
        this.groupMemberAttr = groupMemberAttr;
    }

    public String getUserObjectClass() {
        return this.userObjectClass;
    }

    public void setUserObjectClass(String userObjectClass) {
        this.userObjectClass = userObjectClass;
    }

    public String getGroupObjectClass() {
        return this.groupObjectClass;
    }

    public void setGroupObjectClass(String groupObjectClass) {
        this.groupObjectClass = groupObjectClass;
    }

    public String getTimestampAttr() {
        return this.timestampAttr;
    }

    public void setTimestampAttr(String timestampAttr) {
        this.timestampAttr = timestampAttr;
    }

    public String getUsnAttr() {
        return this.usnAttr;
    }

    public void setUsnAttr(String usnAttr) {
        this.usnAttr = usnAttr;
    }

    public String getAcctStatusAttr() {
        return this.acctStatusAttr;
    }

    public void setAcctStatusAttr(String acctStatusAttr) {
        this.acctStatusAttr = acctStatusAttr;
    }

    public String getSelectedChangedUsersAlgorithm() {
        return this.selectedChangedUsersAlgorithm;
    }

    public void setSelectedChangedUsersAlgorithm(String selectedChangedUsersAlgorithm) {
        this.selectedChangedUsersAlgorithm = selectedChangedUsersAlgorithm;
    }

    public String getSelectedAcctStatusAlgorithm() {
        return this.selectedAcctStatusAlgorithm;
    }

    public void setSelectedAcctStatusAlgorithm(String selectedAcctStatusAlgorithm) {
        this.selectedAcctStatusAlgorithm = selectedAcctStatusAlgorithm;
    }

    public StringPairPropertySelectionModel getFlagComparisonStatusList() {
        return this.trueFalseModel;
    }

    public StringPairPropertySelectionModel getDefaultStatusList() {
        return this.trueFalseModel;
    }

    public StringPairPropertySelectionModel getGuidTypeList() {
        return this.guidTypeList;
    }

    public String getSelectedDefaultStatus() {
        return this.selectedDefaultStatus;
    }

    public void setSelectedDefaultStatus(String selectedDefaultStatus) {
        this.selectedDefaultStatus = selectedDefaultStatus;
    }

    public String getSelectedFlagComparisonStatus() {
        return this.selectedFlagComparisonStatus;
    }

    public void setSelectedFlagComparisonStatus(String selectedFlagComparisonStatus) {
        this.selectedFlagComparisonStatus = selectedFlagComparisonStatus;
    }

    public String getFlagComparisonValue() {
        return this.flagComparisonValue;
    }

    public void setFlagComparisonValue(String flagComparisonValue) {
        this.flagComparisonValue = flagComparisonValue;
    }

    public String getSelectedGuidType() {
        return this.selectedGuidType;
    }

    public void setSelectedGuidType(String selectedGuidType) {
        this.selectedGuidType = selectedGuidType;
    }

    public boolean isActiveDirectory() {
        LdapDataSource d = MgmtFactory.getDataSourceManager().getLdapDataSource(this.sourceId);
        return d != null && d.isActiveDirectoryType();
    }

    public boolean isSunONE() {
        LdapDataSource d = MgmtFactory.getDataSourceManager().getLdapDataSource(this.sourceId);
        return d != null && d.isSunOneType();
    }

    public boolean isPingDirectory() {
        LdapDataSource d = MgmtFactory.getDataSourceManager().getLdapDataSource(this.sourceId);
        return d != null && d.isPingDirectoryType();
    }

    public boolean isPingDS() {
        LdapDataSource d = MgmtFactory.getDataSourceManager().getLdapDataSource(this.sourceId);
        return d != null && d.isPingDSType();
    }

    public boolean isGeneric() {
        LdapDataSource d = MgmtFactory.getDataSourceManager().getLdapDataSource(this.sourceId);
        return d != null && d.isGenericType();
    }

    public boolean isCustom() {
        return !this.isActiveDirectory() && !this.isSunONE() && !this.isPingDirectory() && !this.isPingDS() && !this.isGeneric();
    }

    public boolean isFlagComparisonValueDisabled() {
        return this.selectedAcctStatusAlgorithm == null || !this.selectedAcctStatusAlgorithm.equals("Flag");
    }

    public boolean isFlagComparisonStatusDisabled() {
        return this.selectedAcctStatusAlgorithm == null || !this.selectedAcctStatusAlgorithm.equals("Flag");
    }

    public boolean isUsnAttrDisabled() {
        return this.selectedChangedUsersAlgorithm == null || !this.selectedChangedUsersAlgorithm.equals("Active Directory USN");
    }

    public String getSourceDataSourceId() {
        SaaSChannelTasklet tasklet = (SaaSChannelTasklet)this.getParent();
        return tasklet == null ? "" : tasklet.getSelectedDataSourceId();
    }

    public String getSelectedLdapType() {
        SaaSChannelTasklet tasklet = (SaaSChannelTasklet)this.getParent();
        return tasklet == null ? "" : tasklet.getSelectedLdapType();
    }

    public String getSelectedLdapTypeForDisplay() {
        SaaSChannelTasklet tasklet = (SaaSChannelTasklet)this.getParent();
        return tasklet == null ? "" : tasklet.getSelectedLdapTypeForDisplay();
    }
}

