/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.admin.mgmt;

import com.pingidentity.fsm.state.impl.SaaSGlobalProvisioningSettingsState;
import com.pingidentity.fsm.state.impl.SaaSProvisioningState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.module.connection.admin.AdminConnectionModuleManager;
import com.pingidentity.module.connection.admin.ConnectionModuleState;
import com.pingidentity.module.connection.admin.ModuleType;
import com.pingidentity.module.connection.admin.ServerSettingsState;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerConfig;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerManager;
import com.pingidentity.provisioner.saas.SaasPluginManager;
import com.pingidentity.provisioner.saas.SaasProvisionerPluginInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.license.LicenseManager;

public class ProvisionerAdminManager
implements AdminConnectionModuleManager {
    public static final String MODULE_DESCRIPTION = "Outbound Provisioning";
    private Map<String, ModuleType> moduleTypesMap;

    public ConnectionModuleState createConnectionState(ConnectionTasklet connectionTasklet) {
        return new SaaSProvisioningState((Tasklet)connectionTasklet);
    }

    public ServerSettingsState createServerSettingsState(Tasklet ownerTasklet) {
        return new SaaSGlobalProvisioningSettingsState(ownerTasklet);
    }

    public String getDescription() {
        return MODULE_DESCRIPTION;
    }

    public String getModuleId() {
        return "SaasProvisioner";
    }

    public void appendErrorsForServerSettings(IValidationDelegate validationDelegate, BaseComponent baseComponent) {
        if (!LicenseManager.isFeatureEnabled((String)"SaasProvisioning")) {
            validationDelegate.setFormComponent(null);
            validationDelegate.record("You must have a license to enable Outbound Provisioning.  Please contact sales@pingidentity.com to obtain a license.", ValidationConstraint.REQUIRED);
        }
        if (!validationDelegate.getHasErrors()) {
            Vector<String> missingPlugins = new Vector<String>();
            Collection spConnections = MgmtFactory.getConnectionManager().getFilteredSamlSpConnections();
            for (SpConnection spConnection : spConnections) {
                String connectionTargetType = spConnection.getConnectionTargetType();
                if ("Standard".equals(connectionTargetType) || spConnection.getModuleConfiguration(ProvisionerConfig.class) == null || missingPlugins.contains(connectionTargetType) || SaasPluginManager.getInstance().getPluginInstance(connectionTargetType) != null) continue;
                missingPlugins.add(connectionTargetType);
            }
            if (!missingPlugins.isEmpty()) {
                StringBuffer missingPluginsSB = new StringBuffer();
                Iterator missingPluginsIter = missingPlugins.iterator();
                while (missingPluginsIter.hasNext()) {
                    missingPluginsSB.append((String)missingPluginsIter.next());
                    if (!missingPluginsIter.hasNext()) continue;
                    missingPluginsSB.append(", ");
                }
                validationDelegate.setFormComponent(null);
                validationDelegate.record("The following SaaS Connector(s) are being used by one or more connections but have not been deployed: " + missingPluginsSB + ". Please deploy the Connector(s) and try again.", ValidationConstraint.REQUIRED);
            } else if (SaasPluginManager.getInstance().getNumberOfPluginsLoaded() == 0) {
                validationDelegate.setFormComponent(null);
                validationDelegate.record("Outbound Provisioning requires at least one SaaS Connector to be deployed.  No Connectors found.", ValidationConstraint.REQUIRED);
            }
        }
    }

    public boolean isSelectableInConnection(ConnectionTasklet connectionTasklet) {
        return LicenseManager.isFeatureEnabled((String)"SaasProvisioning") && ProvisionerManager.getProvisionerGlobalSettings().isEnabledInGui();
    }

    public Map<String, ModuleType> getConnectionModuleTypes() {
        if (this.moduleTypesMap != null) {
            return this.moduleTypesMap;
        }
        HashMap<String, ModuleType> tempModuleTypesMap = new HashMap<String, ModuleType>();
        for (String pluginId : SaasPluginManager.getInstance().getPluginIds().keySet()) {
            SaasProvisionerPluginInfo info = SaasPluginManager.getInstance().getPluginInfo(pluginId);
            tempModuleTypesMap.put(pluginId, new ModuleType(pluginId, info.getDescription(), info.isUserSelectable(), info.getFipsStatus()));
        }
        this.moduleTypesMap = tempModuleTypesMap;
        return this.moduleTypesMap;
    }
}

