/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.base;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.twilio.exception.ApiConnectionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Page<T> {
    private final List<T> records;
    private final String firstPageUrl;
    private final String firstPageUri;
    private final String nextPageUrl;
    private final String nextPageUri;
    private final String previousPageUrl;
    private final String previousPageUri;
    private final String url;
    private final String uri;
    private final int pageSize;

    private Page(Builder<T> b) {
        this.records = ((Builder)b).records;
        this.firstPageUri = ((Builder)b).firstPageUri;
        this.firstPageUrl = ((Builder)b).firstPageUrl;
        this.nextPageUri = ((Builder)b).nextPageUri;
        this.nextPageUrl = ((Builder)b).nextPageUrl;
        this.previousPageUri = ((Builder)b).previousPageUri;
        this.previousPageUrl = ((Builder)b).previousPageUrl;
        this.uri = ((Builder)b).uri;
        this.url = ((Builder)b).url;
        this.pageSize = ((Builder)b).pageSize;
    }

    private String urlFromUri(String domain, String region, String uri) {
        return "https://" + Joiner.on((String)".").skipNulls().join((Object)domain, (Object)region, new Object[]{"twilio", "com"}) + uri;
    }

    public List<T> getRecords() {
        return this.records;
    }

    public String getFirstPageUrl(String domain, String region) {
        if (this.firstPageUrl != null) {
            return this.firstPageUrl;
        }
        return this.urlFromUri(domain, region, this.firstPageUri);
    }

    public String getNextPageUrl(String domain, String region) {
        if (this.nextPageUrl != null) {
            return this.nextPageUrl;
        }
        return this.urlFromUri(domain, region, this.nextPageUri);
    }

    public String getPreviousPageUrl(String domain, String region) {
        if (this.previousPageUrl != null) {
            return this.previousPageUrl;
        }
        return this.urlFromUri(domain, region, this.previousPageUri);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getUrl(String domain, String region) {
        if (this.url != null) {
            return this.url;
        }
        return this.urlFromUri(domain, region, this.uri);
    }

    public boolean hasNextPage() {
        return !Strings.isNullOrEmpty((String)this.nextPageUri) || !Strings.isNullOrEmpty((String)this.nextPageUrl);
    }

    public static <T> Page<T> fromJson(String recordKey, String json, Class<T> recordType, ObjectMapper mapper) {
        try {
            ArrayList<Object> results = new ArrayList<Object>();
            JsonNode root = mapper.readTree(json);
            JsonNode records = root.get(recordKey);
            for (JsonNode record : records) {
                results.add(mapper.readValue(record.toString(), recordType));
            }
            JsonNode uriNode = root.get("uri");
            if (uriNode != null) {
                return Page.buildPage(root, results);
            }
            return Page.buildNextGenPage(root, results);
        }
        catch (IOException e) {
            throw new ApiConnectionException("Unable to deserialize response: " + e.getMessage() + "\nJSON: " + json, e);
        }
    }

    private static <T> Page<T> buildPage(JsonNode root, List<T> results) {
        JsonNode pageSizeNode;
        JsonNode firstPageNode;
        JsonNode previousPageNode;
        Builder<T> builder = new Builder().uri(root.get("uri").asText());
        JsonNode nextPageNode = root.get("next_page_uri");
        if (nextPageNode != null && !nextPageNode.isNull()) {
            builder.nextPageUri(nextPageNode.asText());
        }
        if ((previousPageNode = root.get("previous_page_uri")) != null && !previousPageNode.isNull()) {
            builder.previousPageUri(previousPageNode.asText());
        }
        if ((firstPageNode = root.get("first_page_uri")) != null && !firstPageNode.isNull()) {
            builder.firstPageUri(firstPageNode.asText());
        }
        if ((pageSizeNode = root.get("page_size")) != null && !pageSizeNode.isNull()) {
            builder.pageSize(pageSizeNode.asInt());
        } else {
            builder.pageSize(results.size());
        }
        return builder.records(results).build();
    }

    private static <T> Page<T> buildNextGenPage(JsonNode root, List<T> results) {
        JsonNode pageSizeNode;
        JsonNode firstPageNode;
        JsonNode previousPageNode;
        JsonNode meta = root.get("meta");
        Builder<T> builder = new Builder().url(meta.get("url").asText());
        JsonNode nextPageNode = meta.get("next_page_url");
        if (!nextPageNode.isNull()) {
            builder.nextPageUrl(nextPageNode.asText());
        }
        if (!(previousPageNode = meta.get("previous_page_url")).isNull()) {
            builder.previousPageUrl(previousPageNode.asText());
        }
        if (!(firstPageNode = meta.get("first_page_url")).isNull()) {
            builder.firstPageUrl(firstPageNode.asText());
        }
        if (!(pageSizeNode = meta.get("page_size")).isNull()) {
            builder.pageSize(pageSizeNode.asInt());
        } else {
            builder.pageSize(results.size());
        }
        return builder.records(results).build();
    }

    private static class Builder<T> {
        private List<T> records;
        private String firstPageUrl;
        private String firstPageUri;
        private String nextPageUrl;
        private String nextPageUri;
        private String previousPageUrl;
        private String previousPageUri;
        private String uri;
        private String url;
        private int pageSize;

        private Builder() {
        }

        public Builder<T> records(List<T> records) {
            this.records = records;
            return this;
        }

        public Builder<T> firstPageUri(String firstPageUri) {
            this.firstPageUri = firstPageUri;
            return this;
        }

        public Builder<T> firstPageUrl(String firstPageUrl) {
            this.firstPageUrl = firstPageUrl;
            return this;
        }

        public Builder<T> nextPageUri(String nextPageUri) {
            this.nextPageUri = nextPageUri;
            return this;
        }

        public Builder<T> nextPageUrl(String nextPageUrl) {
            this.nextPageUrl = nextPageUrl;
            return this;
        }

        public Builder<T> previousPageUri(String previousPageUri) {
            this.previousPageUri = previousPageUri;
            return this;
        }

        public Builder<T> previousPageUrl(String previousPageUrl) {
            this.previousPageUrl = previousPageUrl;
            return this;
        }

        public Builder<T> uri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder<T> url(String url) {
            this.url = url;
            return this;
        }

        public Builder<T> pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Page<T> build() {
            return new Page(this);
        }
    }
}

