/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.jwt;

import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class Jwt {
    private final SignatureAlgorithm algorithm;
    private final String secret;
    private final String issuer;
    private final Date expiration;

    public Jwt(SignatureAlgorithm algorithm, String secret, String issuer, Date expiration) {
        this.algorithm = algorithm;
        this.secret = secret;
        this.issuer = issuer;
        this.expiration = expiration;
    }

    public String toJwt() {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("typ", "JWT");
        headers.putAll(this.getHeaders());
        JwtBuilder builder = Jwts.builder().signWith(this.algorithm, this.secret.getBytes(StandardCharsets.UTF_8)).setHeaderParams(headers).setIssuer(this.issuer).setExpiration(this.expiration);
        if (this.getClaims() != null) {
            for (Map.Entry<String, Object> entry : this.getClaims().entrySet()) {
                builder.claim(entry.getKey(), entry.getValue());
            }
        }
        if (this.getId() != null) {
            builder.setId(this.getId());
        }
        if (this.getSubject() != null) {
            builder.setSubject(this.getSubject());
        }
        if (this.getNbf() != null) {
            builder.setNotBefore(this.getNbf());
        }
        return builder.compact();
    }

    public String getId() {
        return null;
    }

    public String getSubject() {
        return null;
    }

    public Date getNbf() {
        return null;
    }

    public abstract Map<String, Object> getHeaders();

    public abstract Map<String, Object> getClaims();
}

