/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.Call;
import com.twilio.type.Endpoint;
import com.twilio.type.PhoneNumber;
import java.net.URI;
import java.util.List;

public class CallCreator
extends Creator<Call> {
    private String accountSid;
    private final Endpoint to;
    private final PhoneNumber from;
    private URI url;
    private String applicationSid;
    private HttpMethod method;
    private URI fallbackUrl;
    private HttpMethod fallbackMethod;
    private URI statusCallback;
    private List<String> statusCallbackEvent;
    private HttpMethod statusCallbackMethod;
    private String sendDigits;
    private String ifMachine;
    private Integer timeout;
    private Boolean record;
    private String recordingChannels;
    private String recordingStatusCallback;
    private HttpMethod recordingStatusCallbackMethod;
    private String sipAuthUsername;
    private String sipAuthPassword;

    public CallCreator(Endpoint to, PhoneNumber from, URI url) {
        this.to = to;
        this.from = from;
        this.url = url;
    }

    public CallCreator(String accountSid, Endpoint to, PhoneNumber from, URI url) {
        this.accountSid = accountSid;
        this.to = to;
        this.from = from;
        this.url = url;
    }

    public CallCreator(Endpoint to, PhoneNumber from, String applicationSid) {
        this.to = to;
        this.from = from;
        this.applicationSid = applicationSid;
    }

    public CallCreator(String accountSid, Endpoint to, PhoneNumber from, String applicationSid) {
        this.accountSid = accountSid;
        this.to = to;
        this.from = from;
        this.applicationSid = applicationSid;
    }

    public CallCreator setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    public CallCreator setFallbackUrl(URI fallbackUrl) {
        this.fallbackUrl = fallbackUrl;
        return this;
    }

    public CallCreator setFallbackUrl(String fallbackUrl) {
        return this.setFallbackUrl(Promoter.uriFromString(fallbackUrl));
    }

    public CallCreator setFallbackMethod(HttpMethod fallbackMethod) {
        this.fallbackMethod = fallbackMethod;
        return this;
    }

    public CallCreator setStatusCallback(URI statusCallback) {
        this.statusCallback = statusCallback;
        return this;
    }

    public CallCreator setStatusCallback(String statusCallback) {
        return this.setStatusCallback(Promoter.uriFromString(statusCallback));
    }

    public CallCreator setStatusCallbackEvent(List<String> statusCallbackEvent) {
        this.statusCallbackEvent = statusCallbackEvent;
        return this;
    }

    public CallCreator setStatusCallbackEvent(String statusCallbackEvent) {
        return this.setStatusCallbackEvent(Promoter.listOfOne(statusCallbackEvent));
    }

    public CallCreator setStatusCallbackMethod(HttpMethod statusCallbackMethod) {
        this.statusCallbackMethod = statusCallbackMethod;
        return this;
    }

    public CallCreator setSendDigits(String sendDigits) {
        this.sendDigits = sendDigits;
        return this;
    }

    public CallCreator setIfMachine(String ifMachine) {
        this.ifMachine = ifMachine;
        return this;
    }

    public CallCreator setTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public CallCreator setRecord(Boolean record) {
        this.record = record;
        return this;
    }

    public CallCreator setRecordingChannels(String recordingChannels) {
        this.recordingChannels = recordingChannels;
        return this;
    }

    public CallCreator setRecordingStatusCallback(String recordingStatusCallback) {
        this.recordingStatusCallback = recordingStatusCallback;
        return this;
    }

    public CallCreator setRecordingStatusCallbackMethod(HttpMethod recordingStatusCallbackMethod) {
        this.recordingStatusCallbackMethod = recordingStatusCallbackMethod;
        return this;
    }

    public CallCreator setSipAuthUsername(String sipAuthUsername) {
        this.sipAuthUsername = sipAuthUsername;
        return this;
    }

    public CallCreator setSipAuthPassword(String sipAuthPassword) {
        this.sipAuthPassword = sipAuthPassword;
        return this;
    }

    public CallCreator setUrl(URI url) {
        this.url = url;
        return this;
    }

    public CallCreator setUrl(String url) {
        return this.setUrl(Promoter.uriFromString(url));
    }

    public CallCreator setApplicationSid(String applicationSid) {
        this.applicationSid = applicationSid;
        return this;
    }

    @Override
    public Call create(TwilioRestClient client) {
        this.accountSid = this.accountSid == null ? client.getAccountSid() : this.accountSid;
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), "/2010-04-01/Accounts/" + this.accountSid + "/Calls.json", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Call creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Call.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.to != null) {
            request.addPostParam("To", this.to.getEndpoint());
        }
        if (this.from != null) {
            request.addPostParam("From", this.from.toString());
        }
        if (this.url != null) {
            request.addPostParam("Url", this.url.toString());
        }
        if (this.applicationSid != null) {
            request.addPostParam("ApplicationSid", this.applicationSid);
        }
        if (this.method != null) {
            request.addPostParam("Method", this.method.toString());
        }
        if (this.fallbackUrl != null) {
            request.addPostParam("FallbackUrl", this.fallbackUrl.toString());
        }
        if (this.fallbackMethod != null) {
            request.addPostParam("FallbackMethod", this.fallbackMethod.toString());
        }
        if (this.statusCallback != null) {
            request.addPostParam("StatusCallback", this.statusCallback.toString());
        }
        if (this.statusCallbackEvent != null) {
            for (String prop : this.statusCallbackEvent) {
                request.addPostParam("StatusCallbackEvent", prop);
            }
        }
        if (this.statusCallbackMethod != null) {
            request.addPostParam("StatusCallbackMethod", this.statusCallbackMethod.toString());
        }
        if (this.sendDigits != null) {
            request.addPostParam("SendDigits", this.sendDigits);
        }
        if (this.ifMachine != null) {
            request.addPostParam("IfMachine", this.ifMachine);
        }
        if (this.timeout != null) {
            request.addPostParam("Timeout", this.timeout.toString());
        }
        if (this.record != null) {
            request.addPostParam("Record", this.record.toString());
        }
        if (this.recordingChannels != null) {
            request.addPostParam("RecordingChannels", this.recordingChannels);
        }
        if (this.recordingStatusCallback != null) {
            request.addPostParam("RecordingStatusCallback", this.recordingStatusCallback);
        }
        if (this.recordingStatusCallbackMethod != null) {
            request.addPostParam("RecordingStatusCallbackMethod", this.recordingStatusCallbackMethod.toString());
        }
        if (this.sipAuthUsername != null) {
            request.addPostParam("SipAuthUsername", this.sipAuthUsername);
        }
        if (this.sipAuthPassword != null) {
            request.addPostParam("SipAuthPassword", this.sipAuthPassword);
        }
    }
}

