/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.Call;

public class CallFetcher
extends Fetcher<Call> {
    private String accountSid;
    private final String sid;

    public CallFetcher(String sid) {
        this.sid = sid;
    }

    public CallFetcher(String accountSid, String sid) {
        this.accountSid = accountSid;
        this.sid = sid;
    }

    @Override
    public Call fetch(TwilioRestClient client) {
        this.accountSid = this.accountSid == null ? client.getAccountSid() : this.accountSid;
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), "/2010-04-01/Accounts/" + this.accountSid + "/Calls/" + this.sid + ".json", client.getRegion());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Call fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Call.fromJson(response.getStream(), client.getObjectMapper());
    }
}

