/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.OutgoingCallerIdDeleter;
import com.twilio.rest.api.v2010.account.OutgoingCallerIdFetcher;
import com.twilio.rest.api.v2010.account.OutgoingCallerIdReader;
import com.twilio.rest.api.v2010.account.OutgoingCallerIdUpdater;
import com.twilio.type.PhoneNumber;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OutgoingCallerId
extends Resource {
    private static final long serialVersionUID = 160246512577628L;
    private final String sid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String friendlyName;
    private final String accountSid;
    private final PhoneNumber phoneNumber;
    private final String uri;

    public static OutgoingCallerIdFetcher fetcher(String accountSid, String sid) {
        return new OutgoingCallerIdFetcher(accountSid, sid);
    }

    public static OutgoingCallerIdFetcher fetcher(String sid) {
        return new OutgoingCallerIdFetcher(sid);
    }

    public static OutgoingCallerIdUpdater updater(String accountSid, String sid) {
        return new OutgoingCallerIdUpdater(accountSid, sid);
    }

    public static OutgoingCallerIdUpdater updater(String sid) {
        return new OutgoingCallerIdUpdater(sid);
    }

    public static OutgoingCallerIdDeleter deleter(String accountSid, String sid) {
        return new OutgoingCallerIdDeleter(accountSid, sid);
    }

    public static OutgoingCallerIdDeleter deleter(String sid) {
        return new OutgoingCallerIdDeleter(sid);
    }

    public static OutgoingCallerIdReader reader(String accountSid) {
        return new OutgoingCallerIdReader(accountSid);
    }

    public static OutgoingCallerIdReader reader() {
        return new OutgoingCallerIdReader();
    }

    public static OutgoingCallerId fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (OutgoingCallerId)objectMapper.readValue(json, OutgoingCallerId.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static OutgoingCallerId fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (OutgoingCallerId)objectMapper.readValue(json, OutgoingCallerId.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private OutgoingCallerId(@JsonProperty(value="sid") String sid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="phone_number") PhoneNumber phoneNumber, @JsonProperty(value="uri") String uri) {
        this.sid = sid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.accountSid = accountSid;
        this.phoneNumber = phoneNumber;
        this.uri = uri;
    }

    public final String getSid() {
        return this.sid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutgoingCallerId other = (OutgoingCallerId)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.dateCreated, this.dateUpdated, this.friendlyName, this.accountSid, this.phoneNumber, this.uri);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("friendlyName", (Object)this.friendlyName).add("accountSid", (Object)this.accountSid).add("phoneNumber", (Object)this.phoneNumber).add("uri", (Object)this.uri).toString();
    }
}

