/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.conference;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.conference.Participant;
import com.twilio.type.PhoneNumber;
import java.net.URI;
import java.util.List;

public class ParticipantCreator
extends Creator<Participant> {
    private String accountSid;
    private final String conferenceSid;
    private final PhoneNumber from;
    private final PhoneNumber to;
    private URI statusCallback;
    private HttpMethod statusCallbackMethod;
    private List<String> statusCallbackEvent;
    private Integer timeout;
    private Boolean record;
    private Boolean muted;
    private Participant.Beep beep;
    private Boolean startConferenceOnEnter;
    private Boolean endConferenceOnExit;
    private URI waitUrl;
    private HttpMethod waitMethod;
    private Boolean earlyMedia;
    private Integer maxParticipants;
    private Participant.ConferenceRecord conferenceRecord;
    private String conferenceTrim;
    private URI conferenceStatusCallback;
    private HttpMethod conferenceStatusCallbackMethod;
    private List<String> conferenceStatusCallbackEvent;

    public ParticipantCreator(String conferenceSid, PhoneNumber from, PhoneNumber to) {
        this.conferenceSid = conferenceSid;
        this.from = from;
        this.to = to;
    }

    public ParticipantCreator(String accountSid, String conferenceSid, PhoneNumber from, PhoneNumber to) {
        this.accountSid = accountSid;
        this.conferenceSid = conferenceSid;
        this.from = from;
        this.to = to;
    }

    public ParticipantCreator setStatusCallback(URI statusCallback) {
        this.statusCallback = statusCallback;
        return this;
    }

    public ParticipantCreator setStatusCallback(String statusCallback) {
        return this.setStatusCallback(Promoter.uriFromString(statusCallback));
    }

    public ParticipantCreator setStatusCallbackMethod(HttpMethod statusCallbackMethod) {
        this.statusCallbackMethod = statusCallbackMethod;
        return this;
    }

    public ParticipantCreator setStatusCallbackEvent(List<String> statusCallbackEvent) {
        this.statusCallbackEvent = statusCallbackEvent;
        return this;
    }

    public ParticipantCreator setStatusCallbackEvent(String statusCallbackEvent) {
        return this.setStatusCallbackEvent(Promoter.listOfOne(statusCallbackEvent));
    }

    public ParticipantCreator setTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public ParticipantCreator setRecord(Boolean record) {
        this.record = record;
        return this;
    }

    public ParticipantCreator setMuted(Boolean muted) {
        this.muted = muted;
        return this;
    }

    public ParticipantCreator setBeep(Participant.Beep beep) {
        this.beep = beep;
        return this;
    }

    public ParticipantCreator setStartConferenceOnEnter(Boolean startConferenceOnEnter) {
        this.startConferenceOnEnter = startConferenceOnEnter;
        return this;
    }

    public ParticipantCreator setEndConferenceOnExit(Boolean endConferenceOnExit) {
        this.endConferenceOnExit = endConferenceOnExit;
        return this;
    }

    public ParticipantCreator setWaitUrl(URI waitUrl) {
        this.waitUrl = waitUrl;
        return this;
    }

    public ParticipantCreator setWaitUrl(String waitUrl) {
        return this.setWaitUrl(Promoter.uriFromString(waitUrl));
    }

    public ParticipantCreator setWaitMethod(HttpMethod waitMethod) {
        this.waitMethod = waitMethod;
        return this;
    }

    public ParticipantCreator setEarlyMedia(Boolean earlyMedia) {
        this.earlyMedia = earlyMedia;
        return this;
    }

    public ParticipantCreator setMaxParticipants(Integer maxParticipants) {
        this.maxParticipants = maxParticipants;
        return this;
    }

    public ParticipantCreator setConferenceRecord(Participant.ConferenceRecord conferenceRecord) {
        this.conferenceRecord = conferenceRecord;
        return this;
    }

    public ParticipantCreator setConferenceTrim(String conferenceTrim) {
        this.conferenceTrim = conferenceTrim;
        return this;
    }

    public ParticipantCreator setConferenceStatusCallback(URI conferenceStatusCallback) {
        this.conferenceStatusCallback = conferenceStatusCallback;
        return this;
    }

    public ParticipantCreator setConferenceStatusCallback(String conferenceStatusCallback) {
        return this.setConferenceStatusCallback(Promoter.uriFromString(conferenceStatusCallback));
    }

    public ParticipantCreator setConferenceStatusCallbackMethod(HttpMethod conferenceStatusCallbackMethod) {
        this.conferenceStatusCallbackMethod = conferenceStatusCallbackMethod;
        return this;
    }

    public ParticipantCreator setConferenceStatusCallbackEvent(List<String> conferenceStatusCallbackEvent) {
        this.conferenceStatusCallbackEvent = conferenceStatusCallbackEvent;
        return this;
    }

    public ParticipantCreator setConferenceStatusCallbackEvent(String conferenceStatusCallbackEvent) {
        return this.setConferenceStatusCallbackEvent(Promoter.listOfOne(conferenceStatusCallbackEvent));
    }

    @Override
    public Participant create(TwilioRestClient client) {
        this.accountSid = this.accountSid == null ? client.getAccountSid() : this.accountSid;
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), "/2010-04-01/Accounts/" + this.accountSid + "/Conferences/" + this.conferenceSid + "/Participants.json", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Participant creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Participant.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.from != null) {
            request.addPostParam("From", this.from.toString());
        }
        if (this.to != null) {
            request.addPostParam("To", this.to.toString());
        }
        if (this.statusCallback != null) {
            request.addPostParam("StatusCallback", this.statusCallback.toString());
        }
        if (this.statusCallbackMethod != null) {
            request.addPostParam("StatusCallbackMethod", this.statusCallbackMethod.toString());
        }
        if (this.statusCallbackEvent != null) {
            for (String prop : this.statusCallbackEvent) {
                request.addPostParam("StatusCallbackEvent", prop);
            }
        }
        if (this.timeout != null) {
            request.addPostParam("Timeout", this.timeout.toString());
        }
        if (this.record != null) {
            request.addPostParam("Record", this.record.toString());
        }
        if (this.muted != null) {
            request.addPostParam("Muted", this.muted.toString());
        }
        if (this.beep != null) {
            request.addPostParam("Beep", this.beep.toString());
        }
        if (this.startConferenceOnEnter != null) {
            request.addPostParam("StartConferenceOnEnter", this.startConferenceOnEnter.toString());
        }
        if (this.endConferenceOnExit != null) {
            request.addPostParam("EndConferenceOnExit", this.endConferenceOnExit.toString());
        }
        if (this.waitUrl != null) {
            request.addPostParam("WaitUrl", this.waitUrl.toString());
        }
        if (this.waitMethod != null) {
            request.addPostParam("WaitMethod", this.waitMethod.toString());
        }
        if (this.earlyMedia != null) {
            request.addPostParam("EarlyMedia", this.earlyMedia.toString());
        }
        if (this.maxParticipants != null) {
            request.addPostParam("MaxParticipants", this.maxParticipants.toString());
        }
        if (this.conferenceRecord != null) {
            request.addPostParam("ConferenceRecord", this.conferenceRecord.toString());
        }
        if (this.conferenceTrim != null) {
            request.addPostParam("ConferenceTrim", this.conferenceTrim);
        }
        if (this.conferenceStatusCallback != null) {
            request.addPostParam("ConferenceStatusCallback", this.conferenceStatusCallback.toString());
        }
        if (this.conferenceStatusCallbackMethod != null) {
            request.addPostParam("ConferenceStatusCallbackMethod", this.conferenceStatusCallbackMethod.toString());
        }
        if (this.conferenceStatusCallbackEvent != null) {
            for (String prop : this.conferenceStatusCallbackEvent) {
                request.addPostParam("ConferenceStatusCallbackEvent", prop);
            }
        }
    }
}

