/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.incomingphonenumber;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.incomingphonenumber.Mobile;
import com.twilio.type.PhoneNumber;

public class MobileReader
extends Reader<Mobile> {
    private String ownerAccountSid;
    private Boolean beta;
    private String friendlyName;
    private PhoneNumber phoneNumber;

    public MobileReader() {
    }

    public MobileReader(String ownerAccountSid) {
        this.ownerAccountSid = ownerAccountSid;
    }

    public MobileReader setBeta(Boolean beta) {
        this.beta = beta;
        return this;
    }

    public MobileReader setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public MobileReader setPhoneNumber(PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Override
    public ResourceSet<Mobile> read(TwilioRestClient client) {
        return new ResourceSet<Mobile>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Mobile> firstPage(TwilioRestClient client) {
        this.ownerAccountSid = this.ownerAccountSid == null ? client.getAccountSid() : this.ownerAccountSid;
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), "/2010-04-01/Accounts/" + this.ownerAccountSid + "/IncomingPhoneNumbers/Mobile.json", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Mobile> nextPage(Page<Mobile> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.API.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Mobile> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Mobile read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("incoming_phone_numbers", response.getContent(), Mobile.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.beta != null) {
            request.addQueryParam("Beta", this.beta.toString());
        }
        if (this.friendlyName != null) {
            request.addQueryParam("FriendlyName", this.friendlyName);
        }
        if (this.phoneNumber != null) {
            request.addQueryParam("PhoneNumber", this.phoneNumber.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

