/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.recording;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.recording.AddOnResultDeleter;
import com.twilio.rest.api.v2010.account.recording.AddOnResultFetcher;
import com.twilio.rest.api.v2010.account.recording.AddOnResultReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AddOnResult
extends Resource {
    private static final long serialVersionUID = 178294559429976L;
    private final String sid;
    private final String accountSid;
    private final Status status;
    private final String addOnSid;
    private final String addOnConfigurationSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final DateTime dateCompleted;
    private final String referenceSid;
    private final Map<String, String> subresourceUris;

    public static AddOnResultFetcher fetcher(String accountSid, String referenceSid, String sid) {
        return new AddOnResultFetcher(accountSid, referenceSid, sid);
    }

    public static AddOnResultFetcher fetcher(String referenceSid, String sid) {
        return new AddOnResultFetcher(referenceSid, sid);
    }

    public static AddOnResultReader reader(String accountSid, String referenceSid) {
        return new AddOnResultReader(accountSid, referenceSid);
    }

    public static AddOnResultReader reader(String referenceSid) {
        return new AddOnResultReader(referenceSid);
    }

    public static AddOnResultDeleter deleter(String accountSid, String referenceSid, String sid) {
        return new AddOnResultDeleter(accountSid, referenceSid, sid);
    }

    public static AddOnResultDeleter deleter(String referenceSid, String sid) {
        return new AddOnResultDeleter(referenceSid, sid);
    }

    public static AddOnResult fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (AddOnResult)objectMapper.readValue(json, AddOnResult.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static AddOnResult fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (AddOnResult)objectMapper.readValue(json, AddOnResult.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private AddOnResult(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="status") Status status, @JsonProperty(value="add_on_sid") String addOnSid, @JsonProperty(value="add_on_configuration_sid") String addOnConfigurationSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="date_completed") String dateCompleted, @JsonProperty(value="reference_sid") String referenceSid, @JsonProperty(value="subresource_uris") Map<String, String> subresourceUris) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.status = status;
        this.addOnSid = addOnSid;
        this.addOnConfigurationSid = addOnConfigurationSid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.dateCompleted = DateConverter.rfc2822DateTimeFromString(dateCompleted);
        this.referenceSid = referenceSid;
        this.subresourceUris = subresourceUris;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final String getAddOnSid() {
        return this.addOnSid;
    }

    public final String getAddOnConfigurationSid() {
        return this.addOnConfigurationSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final DateTime getDateCompleted() {
        return this.dateCompleted;
    }

    public final String getReferenceSid() {
        return this.referenceSid;
    }

    public final Map<String, String> getSubresourceUris() {
        return this.subresourceUris;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddOnResult other = (AddOnResult)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.addOnSid, other.addOnSid) && Objects.equals(this.addOnConfigurationSid, other.addOnConfigurationSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.dateCompleted, other.dateCompleted) && Objects.equals(this.referenceSid, other.referenceSid) && Objects.equals(this.subresourceUris, other.subresourceUris);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.status, this.addOnSid, this.addOnConfigurationSid, this.dateCreated, this.dateUpdated, this.dateCompleted, this.referenceSid, this.subresourceUris});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("accountSid", (Object)this.accountSid).add("status", (Object)this.status).add("addOnSid", (Object)this.addOnSid).add("addOnConfigurationSid", (Object)this.addOnConfigurationSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("dateCompleted", (Object)this.dateCompleted).add("referenceSid", (Object)this.referenceSid).add("subresourceUris", this.subresourceUris).toString();
    }

    public static enum Status {
        CANCELED("canceled"),
        COMPLETED("completed"),
        DELETED("deleted"),
        FAILED("failed"),
        IN_PROGRESS("in-progress"),
        INIT("init"),
        PROCESSING("processing"),
        QUEUED("queued");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            String normalized = value.replace("-", "_").toUpperCase();
            try {
                return Status.valueOf(normalized);
            }
            catch (RuntimeException e) {
                return null;
            }
        }
    }
}

