/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.recording.addonresult;

import com.twilio.base.Deleter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.recording.addonresult.Payload;

public class PayloadDeleter
extends Deleter<Payload> {
    private String accountSid;
    private final String referenceSid;
    private final String addOnResultSid;
    private final String sid;

    public PayloadDeleter(String referenceSid, String addOnResultSid, String sid) {
        this.referenceSid = referenceSid;
        this.addOnResultSid = addOnResultSid;
        this.sid = sid;
    }

    public PayloadDeleter(String accountSid, String referenceSid, String addOnResultSid, String sid) {
        this.accountSid = accountSid;
        this.referenceSid = referenceSid;
        this.addOnResultSid = addOnResultSid;
        this.sid = sid;
    }

    @Override
    public boolean delete(TwilioRestClient client) {
        this.accountSid = this.accountSid == null ? client.getAccountSid() : this.accountSid;
        Request request = new Request(HttpMethod.DELETE, Domains.API.toString(), "/2010-04-01/Accounts/" + this.accountSid + "/Recordings/" + this.referenceSid + "/AddOnResults/" + this.addOnResultSid + "/Payloads/" + this.sid + ".json", client.getRegion());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Payload delete failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return response.getStatusCode() == 204;
    }
}

