/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.recording.addonresult;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.recording.addonresult.Payload;

public class PayloadReader
extends Reader<Payload> {
    private String accountSid;
    private final String referenceSid;
    private final String addOnResultSid;

    public PayloadReader(String referenceSid, String addOnResultSid) {
        this.referenceSid = referenceSid;
        this.addOnResultSid = addOnResultSid;
    }

    public PayloadReader(String accountSid, String referenceSid, String addOnResultSid) {
        this.accountSid = accountSid;
        this.referenceSid = referenceSid;
        this.addOnResultSid = addOnResultSid;
    }

    @Override
    public ResourceSet<Payload> read(TwilioRestClient client) {
        return new ResourceSet<Payload>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Payload> firstPage(TwilioRestClient client) {
        this.accountSid = this.accountSid == null ? client.getAccountSid() : this.accountSid;
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), "/2010-04-01/Accounts/" + this.accountSid + "/Recordings/" + this.referenceSid + "/AddOnResults/" + this.addOnResultSid + "/Payloads.json", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Payload> nextPage(Page<Payload> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.API.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Payload> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Payload read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("payloads", response.getContent(), Payload.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

