/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.usage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.http.HttpMethod;
import com.twilio.rest.api.v2010.account.usage.TriggerCreator;
import com.twilio.rest.api.v2010.account.usage.TriggerDeleter;
import com.twilio.rest.api.v2010.account.usage.TriggerFetcher;
import com.twilio.rest.api.v2010.account.usage.TriggerReader;
import com.twilio.rest.api.v2010.account.usage.TriggerUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Trigger
extends Resource {
    private static final long serialVersionUID = 265472878252662L;
    private final String accountSid;
    private final String apiVersion;
    private final HttpMethod callbackMethod;
    private final URI callbackUrl;
    private final String currentValue;
    private final DateTime dateCreated;
    private final DateTime dateFired;
    private final DateTime dateUpdated;
    private final String friendlyName;
    private final Recurring recurring;
    private final String sid;
    private final TriggerField triggerBy;
    private final String triggerValue;
    private final String uri;
    private final UsageCategory usageCategory;
    private final String usageRecordUri;

    public static TriggerFetcher fetcher(String accountSid, String sid) {
        return new TriggerFetcher(accountSid, sid);
    }

    public static TriggerFetcher fetcher(String sid) {
        return new TriggerFetcher(sid);
    }

    public static TriggerUpdater updater(String accountSid, String sid) {
        return new TriggerUpdater(accountSid, sid);
    }

    public static TriggerUpdater updater(String sid) {
        return new TriggerUpdater(sid);
    }

    public static TriggerDeleter deleter(String accountSid, String sid) {
        return new TriggerDeleter(accountSid, sid);
    }

    public static TriggerDeleter deleter(String sid) {
        return new TriggerDeleter(sid);
    }

    public static TriggerCreator creator(String accountSid, URI callbackUrl, String triggerValue, UsageCategory usageCategory) {
        return new TriggerCreator(accountSid, callbackUrl, triggerValue, usageCategory);
    }

    public static TriggerCreator creator(URI callbackUrl, String triggerValue, UsageCategory usageCategory) {
        return new TriggerCreator(callbackUrl, triggerValue, usageCategory);
    }

    public static TriggerReader reader(String accountSid) {
        return new TriggerReader(accountSid);
    }

    public static TriggerReader reader() {
        return new TriggerReader();
    }

    public static Trigger fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Trigger)objectMapper.readValue(json, Trigger.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Trigger fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Trigger)objectMapper.readValue(json, Trigger.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Trigger(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="api_version") String apiVersion, @JsonProperty(value="callback_method") HttpMethod callbackMethod, @JsonProperty(value="callback_url") URI callbackUrl, @JsonProperty(value="current_value") String currentValue, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_fired") String dateFired, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="recurring") Recurring recurring, @JsonProperty(value="sid") String sid, @JsonProperty(value="trigger_by") TriggerField triggerBy, @JsonProperty(value="trigger_value") String triggerValue, @JsonProperty(value="uri") String uri, @JsonProperty(value="usage_category") UsageCategory usageCategory, @JsonProperty(value="usage_record_uri") String usageRecordUri) {
        this.accountSid = accountSid;
        this.apiVersion = apiVersion;
        this.callbackMethod = callbackMethod;
        this.callbackUrl = callbackUrl;
        this.currentValue = currentValue;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateFired = DateConverter.rfc2822DateTimeFromString(dateFired);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.recurring = recurring;
        this.sid = sid;
        this.triggerBy = triggerBy;
        this.triggerValue = triggerValue;
        this.uri = uri;
        this.usageCategory = usageCategory;
        this.usageRecordUri = usageRecordUri;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getApiVersion() {
        return this.apiVersion;
    }

    public final HttpMethod getCallbackMethod() {
        return this.callbackMethod;
    }

    public final URI getCallbackUrl() {
        return this.callbackUrl;
    }

    public final String getCurrentValue() {
        return this.currentValue;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateFired() {
        return this.dateFired;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final Recurring getRecurring() {
        return this.recurring;
    }

    public final String getSid() {
        return this.sid;
    }

    public final TriggerField getTriggerBy() {
        return this.triggerBy;
    }

    public final String getTriggerValue() {
        return this.triggerValue;
    }

    public final String getUri() {
        return this.uri;
    }

    public final UsageCategory getUsageCategory() {
        return this.usageCategory;
    }

    public final String getUsageRecordUri() {
        return this.usageRecordUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Trigger other = (Trigger)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.apiVersion, other.apiVersion) && Objects.equals((Object)this.callbackMethod, (Object)other.callbackMethod) && Objects.equals(this.callbackUrl, other.callbackUrl) && Objects.equals(this.currentValue, other.currentValue) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateFired, other.dateFired) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals((Object)this.recurring, (Object)other.recurring) && Objects.equals(this.sid, other.sid) && Objects.equals((Object)this.triggerBy, (Object)other.triggerBy) && Objects.equals(this.triggerValue, other.triggerValue) && Objects.equals(this.uri, other.uri) && Objects.equals((Object)this.usageCategory, (Object)other.usageCategory) && Objects.equals(this.usageRecordUri, other.usageRecordUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.apiVersion, this.callbackMethod, this.callbackUrl, this.currentValue, this.dateCreated, this.dateFired, this.dateUpdated, this.friendlyName, this.recurring, this.sid, this.triggerBy, this.triggerValue, this.uri, this.usageCategory, this.usageRecordUri});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("apiVersion", (Object)this.apiVersion).add("callbackMethod", (Object)this.callbackMethod).add("callbackUrl", (Object)this.callbackUrl).add("currentValue", (Object)this.currentValue).add("dateCreated", (Object)this.dateCreated).add("dateFired", (Object)this.dateFired).add("dateUpdated", (Object)this.dateUpdated).add("friendlyName", (Object)this.friendlyName).add("recurring", (Object)this.recurring).add("sid", (Object)this.sid).add("triggerBy", (Object)this.triggerBy).add("triggerValue", (Object)this.triggerValue).add("uri", (Object)this.uri).add("usageCategory", (Object)this.usageCategory).add("usageRecordUri", (Object)this.usageRecordUri).toString();
    }

    public static enum TriggerField {
        COUNT("count"),
        USAGE("usage"),
        PRICE("price");

        private final String value;

        private TriggerField(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static TriggerField forValue(String value) {
            String normalized = value.replace("-", "_").toUpperCase();
            try {
                return TriggerField.valueOf(normalized);
            }
            catch (RuntimeException e) {
                return null;
            }
        }
    }

    public static enum Recurring {
        DAILY("daily"),
        MONTHLY("monthly"),
        YEARLY("yearly"),
        ALLTIME("alltime");

        private final String value;

        private Recurring(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Recurring forValue(String value) {
            String normalized = value.replace("-", "_").toUpperCase();
            try {
                return Recurring.valueOf(normalized);
            }
            catch (RuntimeException e) {
                return null;
            }
        }
    }

    public static enum UsageCategory {
        AUTHY_AUTHENTICATIONS("authy-authentications"),
        AUTHY_CALLS_OUTBOUND("authy-calls-outbound"),
        AUTHY_MONTHLY_FEES("authy-monthly-fees"),
        AUTHY_PHONE_INTELLIGENCE("authy-phone-intelligence"),
        AUTHY_PHONE_VERIFICATIONS("authy-phone-verifications"),
        AUTHY_SMS_OUTBOUND("authy-sms-outbound"),
        CALL_PROGESS_EVENTS("call-progess-events"),
        CALLERIDLOOKUPS("calleridlookups"),
        CALLS("calls"),
        CALLS_CLIENT("calls-client"),
        CALLS_GLOBALCONFERENCE("calls-globalconference"),
        CALLS_INBOUND("calls-inbound"),
        CALLS_INBOUND_LOCAL("calls-inbound-local"),
        CALLS_INBOUND_MOBILE("calls-inbound-mobile"),
        CALLS_INBOUND_TOLLFREE("calls-inbound-tollfree"),
        CALLS_OUTBOUND("calls-outbound"),
        CALLS_RECORDINGS("calls-recordings"),
        CALLS_SIP("calls-sip"),
        CALLS_SIP_INBOUND("calls-sip-inbound"),
        CALLS_SIP_OUTBOUND("calls-sip-outbound"),
        CARRIER_LOOKUPS("carrier-lookups"),
        CONVERSATIONS("conversations"),
        CONVERSATIONS_API_REQUESTS("conversations-api-requests"),
        CONVERSATIONS_CONVERSATION_EVENTS("conversations-conversation-events"),
        CONVERSATIONS_ENDPOINT_CONNECTIVITY("conversations-endpoint-connectivity"),
        CONVERSATIONS_EVENTS("conversations-events"),
        CONVERSATIONS_PARTICIPANT_EVENTS("conversations-participant-events"),
        CONVERSATIONS_PARTICIPANTS("conversations-participants"),
        IP_MESSAGING("ip-messaging"),
        IP_MESSAGING_COMMANDS("ip-messaging-commands"),
        IP_MESSAGING_DATA_STORAGE("ip-messaging-data-storage"),
        IP_MESSAGING_DATA_TRANSFER("ip-messaging-data-transfer"),
        IP_MESSAGING_ENDPOINT_CONNECTIVITY("ip-messaging-endpoint-connectivity"),
        LOOKUPS("lookups"),
        MEDIASTORAGE("mediastorage"),
        MMS("mms"),
        MMS_INBOUND("mms-inbound"),
        MMS_INBOUND_LONGCODE("mms-inbound-longcode"),
        MMS_INBOUND_SHORTCODE("mms-inbound-shortcode"),
        MMS_OUTBOUND("mms-outbound"),
        MMS_OUTBOUND_LONGCODE("mms-outbound-longcode"),
        MMS_OUTBOUND_SHORTCODE("mms-outbound-shortcode"),
        MONITOR_READS("monitor-reads"),
        MONITOR_STORAGE("monitor-storage"),
        MONITOR_WRITES("monitor-writes"),
        NUMBER_FORMAT_LOOKUPS("number-format-lookups"),
        PHONENUMBERS("phonenumbers"),
        PHONENUMBERS_CPS("phonenumbers-cps"),
        PHONENUMBERS_EMERGENCY("phonenumbers-emergency"),
        PHONENUMBERS_LOCAL("phonenumbers-local"),
        PHONENUMBERS_MOBILE("phonenumbers-mobile"),
        PHONENUMBERS_SETUPS("phonenumbers-setups"),
        PHONENUMBERS_TOLLFREE("phonenumbers-tollfree"),
        PREMIUMSUPPORT("premiumsupport"),
        RECORDINGS("recordings"),
        RECORDINGSTORAGE("recordingstorage"),
        SHORTCODES("shortcodes"),
        SHORTCODES_CUSTOMEROWNED("shortcodes-customerowned"),
        SHORTCODES_MMS_ENABLEMENT("shortcodes-mms-enablement"),
        SHORTCODES_MPS("shortcodes-mps"),
        SHORTCODES_RANDOM("shortcodes-random"),
        SHORTCODES_UK("shortcodes-uk"),
        SHORTCODES_VANITY("shortcodes-vanity"),
        SMS("sms"),
        SMS_INBOUND("sms-inbound"),
        SMS_INBOUND_LONGCODE("sms-inbound-longcode"),
        SMS_INBOUND_SHORTCODE("sms-inbound-shortcode"),
        SMS_OUTBOUND("sms-outbound"),
        SMS_OUTBOUND_LONGCODE("sms-outbound-longcode"),
        SMS_OUTBOUND_SHORTCODE("sms-outbound-shortcode"),
        TASKROUTER_TASKS("taskrouter-tasks"),
        TOTALPRICE("totalprice"),
        TRANSCRIPTIONS("transcriptions"),
        TRUNKING_CPS("trunking-cps"),
        TRUNKING_EMERGENCY_CALLS("trunking-emergency-calls"),
        TRUNKING_ORIGINATION("trunking-origination"),
        TRUNKING_ORIGINATION_LOCAL("trunking-origination-local"),
        TRUNKING_ORIGINATION_MOBILE("trunking-origination-mobile"),
        TRUNKING_ORIGINATION_TOLLFREE("trunking-origination-tollfree"),
        TRUNKING_RECORDINGS("trunking-recordings"),
        TRUNKING_SECURE("trunking-secure"),
        TRUNKING_TERMINATION("trunking-termination"),
        TURNMEGABYTES("turnmegabytes"),
        TURNMEGABYTES_AUSTRALIA("turnmegabytes-australia"),
        TURNMEGABYTES_BRASIL("turnmegabytes-brasil"),
        TURNMEGABYTES_IRELAND("turnmegabytes-ireland"),
        TURNMEGABYTES_JAPAN("turnmegabytes-japan"),
        TURNMEGABYTES_SINGAPORE("turnmegabytes-singapore"),
        TURNMEGABYTES_USEAST("turnmegabytes-useast"),
        TURNMEGABYTES_USWEST("turnmegabytes-uswest");

        private final String value;

        private UsageCategory(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static UsageCategory forValue(String value) {
            String normalized = value.replace("-", "_").toUpperCase();
            try {
                return UsageCategory.valueOf(normalized);
            }
            catch (RuntimeException e) {
                return null;
            }
        }
    }
}

