/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.chat.v1.service;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.chat.v1.service.Role;
import java.util.List;

public class RoleUpdater
extends Updater<Role> {
    private final String serviceSid;
    private final String sid;
    private final List<String> permission;

    public RoleUpdater(String serviceSid, String sid, List<String> permission) {
        this.serviceSid = serviceSid;
        this.sid = sid;
        this.permission = permission;
    }

    @Override
    public Role update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.CHAT.toString(), "/v1/Services/" + this.serviceSid + "/Roles/" + this.sid + "", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Role update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Role.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.permission != null) {
            for (String prop : this.permission) {
                request.addPostParam("Permission", prop);
            }
        }
    }
}

