/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.chat.v1.service.channel;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.chat.v1.service.channel.Invite;
import java.util.List;

public class InviteReader
extends Reader<Invite> {
    private final String serviceSid;
    private final String channelSid;
    private List<String> identity;

    public InviteReader(String serviceSid, String channelSid) {
        this.serviceSid = serviceSid;
        this.channelSid = channelSid;
    }

    public InviteReader setIdentity(List<String> identity) {
        this.identity = identity;
        return this;
    }

    public InviteReader setIdentity(String identity) {
        return this.setIdentity(Promoter.listOfOne(identity));
    }

    @Override
    public ResourceSet<Invite> read(TwilioRestClient client) {
        return new ResourceSet<Invite>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Invite> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.CHAT.toString(), "/v1/Services/" + this.serviceSid + "/Channels/" + this.channelSid + "/Invites", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Invite> nextPage(Page<Invite> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.CHAT.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Invite> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Invite read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("invites", response.getContent(), Invite.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.identity != null) {
            for (String prop : this.identity) {
                request.addQueryParam("Identity", prop);
            }
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

