/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.ipmessaging.v1;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.ipmessaging.v1.Credential;

public class CredentialUpdater
extends Updater<Credential> {
    private final String sid;
    private String friendlyName;
    private String certificate;
    private String privateKey;
    private Boolean sandbox;
    private String apiKey;
    private String secret;

    public CredentialUpdater(String sid) {
        this.sid = sid;
    }

    public CredentialUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public CredentialUpdater setCertificate(String certificate) {
        this.certificate = certificate;
        return this;
    }

    public CredentialUpdater setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public CredentialUpdater setSandbox(Boolean sandbox) {
        this.sandbox = sandbox;
        return this;
    }

    public CredentialUpdater setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public CredentialUpdater setSecret(String secret) {
        this.secret = secret;
        return this;
    }

    @Override
    public Credential update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.IPMESSAGING.toString(), "/v1/Credentials/" + this.sid + "", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Credential update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Credential.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.certificate != null) {
            request.addPostParam("Certificate", this.certificate);
        }
        if (this.privateKey != null) {
            request.addPostParam("PrivateKey", this.privateKey);
        }
        if (this.sandbox != null) {
            request.addPostParam("Sandbox", this.sandbox.toString());
        }
        if (this.apiKey != null) {
            request.addPostParam("ApiKey", this.apiKey);
        }
        if (this.secret != null) {
            request.addPostParam("Secret", this.secret);
        }
    }
}

