/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.ipmessaging.v1.service;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.ipmessaging.v1.service.User;

public class UserFetcher
extends Fetcher<User> {
    private final String serviceSid;
    private final String sid;

    public UserFetcher(String serviceSid, String sid) {
        this.serviceSid = serviceSid;
        this.sid = sid;
    }

    @Override
    public User fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.IPMESSAGING.toString(), "/v1/Services/" + this.serviceSid + "/Users/" + this.sid + "", client.getRegion());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("User fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return User.fromJson(response.getStream(), client.getObjectMapper());
    }
}

