/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.pricing.v1.messaging;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.CurrencyDeserializer;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.pricing.v1.messaging.CountryFetcher;
import com.twilio.rest.pricing.v1.messaging.CountryReader;
import com.twilio.type.InboundSmsPrice;
import com.twilio.type.OutboundSmsPrice;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Currency;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Country
extends Resource {
    private static final long serialVersionUID = 155838537182593L;
    private final String country;
    private final String isoCountry;
    private final List<OutboundSmsPrice> outboundSmsPrices;
    private final List<InboundSmsPrice> inboundSmsPrices;
    private final Currency priceUnit;
    private final URI url;

    public static CountryReader reader() {
        return new CountryReader();
    }

    public static CountryFetcher fetcher(String isoCountry) {
        return new CountryFetcher(isoCountry);
    }

    public static Country fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Country)objectMapper.readValue(json, Country.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Country fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Country)objectMapper.readValue(json, Country.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Country(@JsonProperty(value="country") String country, @JsonProperty(value="iso_country") String isoCountry, @JsonProperty(value="outbound_sms_prices") List<OutboundSmsPrice> outboundSmsPrices, @JsonProperty(value="inbound_sms_prices") List<InboundSmsPrice> inboundSmsPrices, @JsonProperty(value="price_unit") @JsonDeserialize(using=CurrencyDeserializer.class) Currency priceUnit, @JsonProperty(value="url") URI url) {
        this.country = country;
        this.isoCountry = isoCountry;
        this.outboundSmsPrices = outboundSmsPrices;
        this.inboundSmsPrices = inboundSmsPrices;
        this.priceUnit = priceUnit;
        this.url = url;
    }

    public final String getSid() {
        return this.getIsoCountry();
    }

    public final String getCountry() {
        return this.country;
    }

    public final String getIsoCountry() {
        return this.isoCountry;
    }

    public final List<OutboundSmsPrice> getOutboundSmsPrices() {
        return this.outboundSmsPrices;
    }

    public final List<InboundSmsPrice> getInboundSmsPrices() {
        return this.inboundSmsPrices;
    }

    public final Currency getPriceUnit() {
        return this.priceUnit;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Country other = (Country)o;
        return Objects.equals(this.country, other.country) && Objects.equals(this.isoCountry, other.isoCountry) && Objects.equals(this.outboundSmsPrices, other.outboundSmsPrices) && Objects.equals(this.inboundSmsPrices, other.inboundSmsPrices) && Objects.equals(this.priceUnit, other.priceUnit) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.country, this.isoCountry, this.outboundSmsPrices, this.inboundSmsPrices, this.priceUnit, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("country", (Object)this.country).add("isoCountry", (Object)this.isoCountry).add("outboundSmsPrices", this.outboundSmsPrices).add("inboundSmsPrices", this.inboundSmsPrices).add("priceUnit", (Object)this.priceUnit).add("url", (Object)this.url).toString();
    }
}

