/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace.taskqueue;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.taskrouter.v1.workspace.taskqueue.TaskQueueStatisticsFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TaskQueueStatistics
extends Resource {
    private static final long serialVersionUID = 25740453860502L;
    private final String accountSid;
    private final Map<String, Object> cumulative;
    private final Map<String, Object> realtime;
    private final String taskQueueSid;
    private final String workspaceSid;
    private final URI url;

    public static TaskQueueStatisticsFetcher fetcher(String workspaceSid, String taskQueueSid) {
        return new TaskQueueStatisticsFetcher(workspaceSid, taskQueueSid);
    }

    public static TaskQueueStatistics fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (TaskQueueStatistics)objectMapper.readValue(json, TaskQueueStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static TaskQueueStatistics fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (TaskQueueStatistics)objectMapper.readValue(json, TaskQueueStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private TaskQueueStatistics(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="cumulative") Map<String, Object> cumulative, @JsonProperty(value="realtime") Map<String, Object> realtime, @JsonProperty(value="task_queue_sid") String taskQueueSid, @JsonProperty(value="workspace_sid") String workspaceSid, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.cumulative = cumulative;
        this.realtime = realtime;
        this.taskQueueSid = taskQueueSid;
        this.workspaceSid = workspaceSid;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Map<String, Object> getCumulative() {
        return this.cumulative;
    }

    public final Map<String, Object> getRealtime() {
        return this.realtime;
    }

    public final String getTaskQueueSid() {
        return this.taskQueueSid;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskQueueStatistics other = (TaskQueueStatistics)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.cumulative, other.cumulative) && Objects.equals(this.realtime, other.realtime) && Objects.equals(this.taskQueueSid, other.taskQueueSid) && Objects.equals(this.workspaceSid, other.workspaceSid) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.cumulative, this.realtime, this.taskQueueSid, this.workspaceSid, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("cumulative", this.cumulative).add("realtime", this.realtime).add("taskQueueSid", (Object)this.taskQueueSid).add("workspaceSid", (Object)this.workspaceSid).add("url", (Object)this.url).toString();
    }
}

