/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trunking.v1;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.trunking.v1.Trunk;
import java.net.URI;

public class TrunkCreator
extends Creator<Trunk> {
    private String friendlyName;
    private String domainName;
    private URI disasterRecoveryUrl;
    private HttpMethod disasterRecoveryMethod;
    private String recording;
    private Boolean secure;

    public TrunkCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public TrunkCreator setDomainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    public TrunkCreator setDisasterRecoveryUrl(URI disasterRecoveryUrl) {
        this.disasterRecoveryUrl = disasterRecoveryUrl;
        return this;
    }

    public TrunkCreator setDisasterRecoveryUrl(String disasterRecoveryUrl) {
        return this.setDisasterRecoveryUrl(Promoter.uriFromString(disasterRecoveryUrl));
    }

    public TrunkCreator setDisasterRecoveryMethod(HttpMethod disasterRecoveryMethod) {
        this.disasterRecoveryMethod = disasterRecoveryMethod;
        return this;
    }

    public TrunkCreator setRecording(String recording) {
        this.recording = recording;
        return this;
    }

    public TrunkCreator setSecure(Boolean secure) {
        this.secure = secure;
        return this;
    }

    @Override
    public Trunk create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.TRUNKING.toString(), "/v1/Trunks", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Trunk creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Trunk.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.domainName != null) {
            request.addPostParam("DomainName", this.domainName);
        }
        if (this.disasterRecoveryUrl != null) {
            request.addPostParam("DisasterRecoveryUrl", this.disasterRecoveryUrl.toString());
        }
        if (this.disasterRecoveryMethod != null) {
            request.addPostParam("DisasterRecoveryMethod", this.disasterRecoveryMethod.toString());
        }
        if (this.recording != null) {
            request.addPostParam("Recording", this.recording);
        }
        if (this.secure != null) {
            request.addPostParam("Secure", this.secure.toString());
        }
    }
}

