/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.twilio.twiml.Event;
import com.twilio.twiml.Method;
import com.twilio.twiml.TwiML;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;

@XmlRootElement(name="Number")
public class Number
extends TwiML {
    @XmlAttribute
    private final String sendDigits;
    @XmlAttribute
    private final String url;
    @XmlAttribute
    private final Method method;
    @XmlAttribute
    private final String statusCallbackEvent;
    @XmlAttribute
    private final String statusCallback;
    @XmlAttribute
    private final Method statusCallbackMethod;
    @XmlValue
    private final String number;
    private final List<Event> statusCallbackEvents;

    private Number() {
        this(new Builder(null));
    }

    private Number(Builder b) {
        this.sendDigits = b.sendDigits;
        this.url = b.url;
        this.method = b.method;
        this.number = b.number;
        this.statusCallbackEvents = b.statusCallbackEvents;
        this.statusCallback = b.statusCallback;
        this.statusCallbackMethod = b.statusCallbackMethod;
        this.statusCallbackEvent = this.statusCallbackEvents != null ? Joiner.on((String)" ").join((Iterable)Lists.transform(this.statusCallbackEvents, Event.TO_STRING)) : null;
    }

    public String getSendDigits() {
        return this.sendDigits;
    }

    public String getUrl() {
        return this.url;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getNumber() {
        return this.number;
    }

    public List<Event> getStatusCallbackEvents() {
        return this.statusCallbackEvents;
    }

    public String getStatusCallback() {
        return this.statusCallback;
    }

    public Method getStatusCallbackMethod() {
        return this.statusCallbackMethod;
    }

    public static class Builder {
        private String sendDigits;
        private String url;
        private Method method;
        private String number;
        private List<Event> statusCallbackEvents;
        private String statusCallback;
        private Method statusCallbackMethod;

        public Builder(String number) {
            this.number = number;
        }

        public Builder sendDigits(String sendDigits) {
            this.sendDigits = sendDigits;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder method(Method method) {
            this.method = method;
            return this;
        }

        public Builder statusCallbackEvents(List<Event> statusCallbackEvents) {
            this.statusCallbackEvents = statusCallbackEvents;
            return this;
        }

        public Builder statusCallback(String statusCallback) {
            this.statusCallback = statusCallback;
            return this;
        }

        public Builder statusCallbackMethod(Method statusCallbackMethod) {
            this.statusCallbackMethod = statusCallbackMethod;
            return this;
        }

        public Number build() {
            return new Number(this);
        }
    }
}

