/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.api;

import com.unboundid.messages.Message;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public class ApiException
extends WebApplicationException {
    private static final long serialVersionUID = 1375129971852299927L;
    private final Message message;
    private final int status;

    public ApiException() {
        this.message = null;
        this.status = 500;
    }

    public ApiException(Message m) {
        super((String)null, Response.serverError().build());
        this.message = m;
        this.status = 500;
    }

    public ApiException(Response response) {
        super(response);
        this.message = null;
        this.status = response != null ? response.getStatus() : 500;
    }

    public ApiException(Message m, Throwable cause) {
        super(cause, Response.serverError().build());
        this.message = m;
        this.status = 500;
    }

    public ApiException(Message m, Response response) {
        this(m, response, null);
    }

    public ApiException(Message m, int status) {
        this(m, status, null);
    }

    public ApiException(Message m, Response.Status responseStatus) {
        this(m, responseStatus, null);
    }

    public ApiException(Message m, Response response, Throwable cause) {
        super(cause, response);
        this.message = m;
        this.status = response.getStatus();
    }

    public ApiException(Message m, int status, Throwable cause) {
        super(cause, status);
        this.message = m;
        this.status = status;
    }

    public ApiException(Message m, Response.Status status, Throwable cause) {
        super(cause, status);
        this.message = m;
        this.status = status.getStatusCode();
    }

    public Message getMessageObject() {
        return this.message;
    }

    public int getStatus() {
        return this.status;
    }

    public String getMessage() {
        Message message = this.getMessageObject();
        return message == null ? "" : message.toString();
    }
}

