/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.debug;

import java.util.ArrayList;
import java.util.HashSet;

public class LogLevel {
    public static final String LOG_SEVERITY_DISABLED = "disabled";
    public static final String LOG_SEVERITY_ALL = "all";
    public static final String LOG_SEVERITY_NONE = "none";
    public static final String DEBUG_SEVERITY_VERBOSE = "verbose";
    public static final String DEBUG_SEVERITY_INFO = "info";
    public static final String DEBUG_SEVERITY_WARNING = "warning";
    public static final String DEBUG_SEVERITY_ERROR = "error";
    private static ArrayList<LogLevel> known = new ArrayList();
    public static final LogLevel DISABLED = new LogLevel("disabled", Integer.MAX_VALUE);
    public static final LogLevel ALL = new LogLevel("all", Integer.MIN_VALUE);
    private final String name;
    private final int value;

    protected LogLevel(String name, int value) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.value = value;
        known.add(this);
    }

    public String getName() {
        return this.name;
    }

    public final String toString() {
        return this.name;
    }

    public final int intValue() {
        return this.value;
    }

    public static synchronized LogLevel parse(String name) throws IllegalArgumentException {
        name.length();
        for (int i = 0; i < known.size(); ++i) {
            LogLevel l = known.get(i);
            if (!name.equalsIgnoreCase(l.name)) continue;
            return l;
        }
        try {
            int x = Integer.parseInt(name);
            for (int i = 0; i < known.size(); ++i) {
                LogLevel l = known.get(i);
                if (l.value != x) continue;
                return l;
            }
            return new LogLevel(name, x);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Bad level \"" + name + "\"");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogLevel logLevel = (LogLevel)o;
        return this.value == logLevel.value;
    }

    public int hashCode() {
        return this.value;
    }

    public static HashSet<String> getLevelStrings() {
        HashSet<String> strings = new HashSet<String>();
        for (int i = 0; i < known.size(); ++i) {
            strings.add(LogLevel.known.get((int)i).name.toLowerCase());
        }
        return strings;
    }
}

