/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.license;

import com.google.common.io.BaseEncoding;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

class HashUtil {
    private static final String UTF_8 = "UTF-8";

    HashUtil() {
    }

    static String hashToHexString(String s, String algo) {
        if (s == null) {
            return null;
        }
        byte[] bytes = HashUtil.toBytes(s);
        return HashUtil.hashToHexString(bytes, algo);
    }

    private static byte[] hashToBytes(byte[] bytes, String algo) {
        MessageDigest digester = HashUtil.getMessageDigester(algo);
        return digester.digest(bytes);
    }

    private static String hashToHexString(byte[] bytes, String algo) {
        if (bytes == null) {
            return null;
        }
        byte[] hashedBytes = HashUtil.hashToBytes(bytes, algo);
        return BaseEncoding.base16().lowerCase().encode(hashedBytes);
    }

    private static MessageDigest getMessageDigester(String algo) {
        MessageDigest digester;
        try {
            digester = MessageDigest.getInstance(algo);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return digester;
    }

    private static byte[] toBytes(String s) {
        try {
            return s.getBytes(UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

