/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.license;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.smardec.license4j.License;
import com.smardec.license4j.LicenseManager;
import com.smardec.license4j.LicenseNotFoundException;
import com.unboundid.common.debug.CommonDebugTracer;
import com.unboundid.common.debug.DebugLogLevel;
import com.unboundid.common.debug.DebugLogger;
import com.unboundid.common.license.HashUtil;
import com.unboundid.common.messages.UBIDCommonMessages;
import com.unboundid.common.util.Validator;
import com.unboundid.messages.Message;
import com.unboundid.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

public final class PingLicense {
    public static final String ALLOW_INVALID = "com.unboundid.common.license.AllowInvalidLicense";
    private static final CommonDebugTracer TRACER = DebugLogger.getTracer();
    private static final String ID = "ID";
    private static final String NAME = "Name";
    private static final String ORGANIZATION = "Organization";
    private static final String PRODUCT = "Product";
    private static final String VERSION = "Version";
    private static final String ISSUEDATE = "IssueDate";
    private static final String EXPIRATIONDATE = "ExpirationDate";
    private static final String TYPE = "Tier";
    private License license;
    private boolean valid;
    private long initTimestamp = 0L;
    private File licenseFileName;
    private String rawData;
    private static String PREFIX_ENCODED = "ENCODED";
    private static String DELIMITER = ":";
    private static String PUBLIC_KEY = "308201B73082012C06072A8648CE3804013082011F02818100FD7F53811D75122952DF4A9C2EECE4E7F611B7523CEF4400C31E3F80B6512669455D402251FB593D8D58FABFC5F5BA30F6CB9B556CD7813B801D346FF26660B76B9950A5A49F9FE8047B1022C24FBBA9D7FEB7C61BF83B57E7C6A8A6150F04FB83F6D3C51EC3023554135A169132F675F3AE2B61D72AEFF22203199DD14801C70215009760508F15230BCCB292B982A2EB840BF0581CF502818100F7E1A085D69B3DDECBBCAB5C36B857B97994AFBBFA3AEA82F9574C0B3D0782675159578EBAD4594FE67107108180B449167123E84C281613B7CF09328CC8A6E13C167A8B547C8D28E0A3AE1E2BB3A675916EA37F0BFA213562F1FB627A01243BCCA4F1BEA8519089A883DFE15AE59F06928B665E807B552564014C3BFECF492A03818400028180243EC413CAECA15C34A20B76BF851B3E49A280474B2F1CEB5B68655768FE4F1D7EC7801A2EA8F053577B7F9AE0C9A7D0EAB2A7678C7C53631DF60441D8978BA627E28CF3C42AE42AE9D3D60DBCAAC59145F304B502BA1F6108048828B26F22FF7EF08101AFAF68325EEC4CD41BA4DC70C66C6A819B65C10622D62B058E63B4DE";

    public static PingLicense fromString(String licenseKey, int expectedMajorVersion, List<String> expectedProducts, List<Message> errors) {
        String licenseProductRegex = UBIDCommonMessages.ERR_LICENSE_PRODUCT.get((Object)"%s", (Object)"%s").toString().replace("%s", ".*");
        Pattern licenseProductPattern = Pattern.compile(licenseProductRegex);
        for (int i = 0; i < expectedProducts.size(); ++i) {
            int j;
            PingLicense license = PingLicense.fromString(licenseKey, expectedMajorVersion, expectedProducts.get(i), errors);
            if (errors.isEmpty() || Boolean.getBoolean(ALLOW_INVALID)) {
                return license;
            }
            if (expectedProducts.size() <= 1 || (j = 0) >= errors.size()) continue;
            if (errors.get(j).equals((Object)UBIDCommonMessages.ERR_LICENSE_NOT_A_LICENSE.get())) {
                return null;
            }
            if (licenseProductPattern.matcher(errors.get(j).toString()).matches()) {
                if (i == expectedProducts.size() - 1) {
                    errors.remove(j);
                    errors.add(j, UBIDCommonMessages.ERR_LICENSE_TWO_PRODUCTS.get((Object)expectedProducts.get(0), (Object)expectedProducts.get(1)));
                    return null;
                }
                errors.clear();
                continue;
            }
            return null;
        }
        return null;
    }

    public static PingLicense fromFile(File licenseFile, int expectedMajorVersion, List<String> expectedProducts, List<Message> errors) {
        String licenseProductRegex = UBIDCommonMessages.ERR_LICENSE_PRODUCT.get((Object)"%s", (Object)"%s").toString().replace("%s", ".*");
        Pattern licenseProductPattern = Pattern.compile(licenseProductRegex);
        for (int i = 0; i < expectedProducts.size(); ++i) {
            int j;
            PingLicense license = PingLicense.fromFile(licenseFile, expectedMajorVersion, expectedProducts.get(i), errors);
            if (errors.isEmpty() || Boolean.getBoolean(ALLOW_INVALID)) {
                return license;
            }
            if (expectedProducts.size() <= 1 || (j = 0) >= errors.size()) continue;
            if (errors.get(j).equals((Object)UBIDCommonMessages.ERR_LICENSE_NOT_A_LICENSE.get())) {
                return null;
            }
            if (licenseProductPattern.matcher(errors.get(j).toString()).matches()) {
                if (i == expectedProducts.size() - 1) {
                    errors.remove(j);
                    errors.add(j, UBIDCommonMessages.ERR_LICENSE_TWO_PRODUCTS.get((Object)expectedProducts.get(0), (Object)expectedProducts.get(1)));
                    return null;
                }
                errors.clear();
                continue;
            }
            return null;
        }
        return null;
    }

    public static PingLicense fromString(String licenseKey, int expectedMajorVersion, String expectedProduct, List<Message> errors) {
        try {
            PingLicense license = new PingLicense(licenseKey);
            PingLicense.checkLicense(license, expectedMajorVersion, expectedProduct, errors);
            return license;
        }
        catch (LicenseNotFoundException lnfe) {
            errors.add(UBIDCommonMessages.ERR_LICENSE_NOT_A_LICENSE.get());
            return null;
        }
    }

    public static PingLicense fromFile(File licenseFile, int expectedMajorVersion, String expectedProduct, List<Message> errors) {
        try {
            PingLicense license = new PingLicense(licenseFile);
            PingLicense.checkLicense(license, expectedMajorVersion, expectedProduct, errors);
            return license;
        }
        catch (LicenseNotFoundException lnfe) {
            errors.add(UBIDCommonMessages.ERR_LICENSE_NOT_A_LICENSE.get());
            return null;
        }
    }

    public static boolean checkLicense(PingLicense license, int expectedMajorVersion, String expectedProduct, List<Message> errors) {
        int preExistingErrors = errors.size();
        if (license.isValid() || Boolean.getBoolean(ALLOW_INVALID)) {
            if (!license.isValidProduct(expectedProduct)) {
                errors.add(UBIDCommonMessages.ERR_LICENSE_PRODUCT.get((Object)license.getProduct(), (Object)expectedProduct));
            }
            if (!license.isValidVersion(expectedMajorVersion, 0)) {
                errors.add(UBIDCommonMessages.ERR_LICENSE_VERSION.get((Object)license.getVersion(), (Object)Integer.toString(expectedMajorVersion)));
            }
            if (license.isExpired()) {
                SimpleDateFormat fmt = new SimpleDateFormat("dd/MMM/yyyy HH:mm:ss Z");
                errors.add(UBIDCommonMessages.ERR_LICENSE_EXPIRED.get((Object)fmt.format(license.getExpirationDate())));
            }
        } else {
            errors.add(UBIDCommonMessages.ERR_LICENSE_INVALID.get());
        }
        return preExistingErrors == errors.size();
    }

    public PingLicense(String rawData) throws LicenseNotFoundException {
        this.rawData = rawData;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(rawData.getBytes("UTF-8"));
            this.loadValidateLicense(is);
        }
        catch (UnsupportedEncodingException uee) {
            Validator.logUnexpectedError(uee);
        }
    }

    private void loadValidateLicense(ByteArrayInputStream is) throws LicenseNotFoundException {
        this.license = LicenseManager.loadLicense((InputStream)is);
        LicenseManager.setPublicKey((String)PUBLIC_KEY);
        try {
            this.valid = LicenseManager.isValid((License)this.license);
            if (!this.valid) {
                throw new GeneralSecurityException("License File is invalid.");
            }
            TRACER.debugInfo("License loaded: " + this.license);
        }
        catch (GeneralSecurityException e) {
            this.valid = false;
            TRACER.debugCaught(DebugLogLevel.WARNING, e);
        }
    }

    public PingLicense(File licenseFile) throws LicenseNotFoundException {
        this.licenseFileName = licenseFile;
        LicenseManager.setPublicKey((String)PUBLIC_KEY);
        try {
            this.license = LicenseManager.loadLicense((String)licenseFile.getPath());
            this.initTimestamp = licenseFile.lastModified();
            this.valid = LicenseManager.isValid((License)this.license);
            TRACER.debugInfo("License loaded: " + this.license);
        }
        catch (GeneralSecurityException e) {
            this.valid = false;
            TRACER.debugCaught(DebugLogLevel.WARNING, e);
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    File getFile() {
        return this.licenseFileName;
    }

    public boolean isValidProduct(String expectedProduct) {
        String licenseProduct = this.getProduct();
        if (expectedProduct == null || licenseProduct == null) {
            return false;
        }
        String expected = expectedProduct.replaceAll("\\s", "").toLowerCase();
        String actual = licenseProduct.replaceAll("\\s", "").toLowerCase();
        return actual.equals(expected);
    }

    public String getProduct() {
        return this.getFeature(PRODUCT);
    }

    public boolean isValidVersion(int major, int minor) {
        return this.isValidMajorVersion(major);
    }

    public boolean isValidMajorVersion(int major) {
        String feature = this.getVersion();
        if (feature != null) {
            int licMajor;
            String[] strings = feature.split("\\.");
            try {
                licMajor = Integer.parseInt(strings[0]);
            }
            catch (Exception e) {
                TRACER.debugCaught(DebugLogLevel.WARNING, e);
                licMajor = -1;
            }
            return major <= licMajor;
        }
        return false;
    }

    public String getVersion() {
        return this.getFeature(VERSION);
    }

    public boolean isExpiredWithRespectTo(Date date) {
        boolean isExp = false;
        Date expirationDate = this.getExpirationDate();
        if (!this.isPerpetual() && expirationDate != null) {
            isExp = date.after(expirationDate);
        }
        return isExp;
    }

    public boolean isExpired() {
        return this.isExpiredWithRespectTo(new Date());
    }

    public Date getExpirationDate() {
        Date exDate = null;
        String feature = this.getFeature(EXPIRATIONDATE);
        if (!PingLicense.isBlank(feature)) {
            try {
                exDate = this.parseDate(feature);
            }
            catch (ParseException e) {
                exDate = new Date(0L);
                TRACER.debugCaught(DebugLogLevel.WARNING, e);
            }
        }
        return exDate;
    }

    public String getID() {
        return this.getFeature(ID);
    }

    public String getName() {
        return this.getFeature(NAME);
    }

    public String getOrganization() {
        return this.getFeature(ORGANIZATION);
    }

    public Date getIssueDate() {
        Date issueDate = null;
        String feature = this.getFeature(ISSUEDATE);
        if (!PingLicense.isBlank(feature)) {
            try {
                issueDate = this.parseDate(feature);
            }
            catch (ParseException e) {
                issueDate = new Date(0L);
                TRACER.debugCaught(DebugLogLevel.WARNING, e);
            }
        }
        return issueDate;
    }

    public boolean isPerpetual() {
        return "Perpetual".equals(this.getType());
    }

    public String getType() {
        return this.getFeature(TYPE);
    }

    public boolean licenseFileExists() {
        return this.license != null;
    }

    public String getFileData() throws IOException {
        if (this.rawData == null) {
            this.rawData = this.licenseFileExists() ? Files.toString((File)this.getFile(), (Charset)Charsets.UTF_8) : "";
        }
        return this.rawData;
    }

    public String toString() {
        try {
            return this.getFileData();
        }
        catch (IOException e) {
            return "invalid certificate: " + e.toString();
        }
    }

    private boolean exceeds(long num, String name) {
        boolean exceeds = false;
        Long transactionLimit = this.getLongLimit(name);
        if (transactionLimit != null) {
            exceeds = num > transactionLimit;
        }
        return exceeds;
    }

    private Integer getIntLimit(String featureName) {
        Long longLimit = this.getLongLimit(featureName);
        return longLimit != null ? Integer.valueOf(longLimit.intValue()) : null;
    }

    private Long getLongLimit(String featureName) {
        Long limit = null;
        String feature = this.getFeature(featureName);
        if (!PingLicense.isBlank(feature)) {
            try {
                limit = Long.parseLong(feature);
            }
            catch (NumberFormatException e) {
                TRACER.debugCaught(DebugLogLevel.WARNING, e);
                limit = 0L;
            }
        }
        return limit;
    }

    private boolean check(int field, int num) {
        return (field & num) == field;
    }

    public String getFeature(String name) {
        return this.license != null ? this.decodeSpecialLicenseChars(this.license.getFeatureAsString(name)) : null;
    }

    private String decodeSpecialLicenseChars(String encoded) {
        String recalculatedHash;
        String[] tokens;
        String value = encoded;
        if (encoded != null && encoded.startsWith(PREFIX_ENCODED + DELIMITER) && (tokens = encoded.split(DELIMITER)).length == 3 && (recalculatedHash = HashUtil.hashToHexString(tokens[1], "SHA1")).equalsIgnoreCase(tokens[2])) {
            try {
                byte[] b64decoded = Base64.decode((String)tokens[1]);
                value = new String(b64decoded, "UTF-8");
            }
            catch (Exception pe) {
                TRACER.debugCaught(DebugLogLevel.ERROR, pe);
            }
        }
        return value;
    }

    private Date parseDate(String dateStr) throws ParseException {
        Date retDate = null;
        SimpleDateFormat dateParser = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateParserFormat2 = new SimpleDateFormat("MM/dd/yyyy");
        try {
            retDate = dateParser.parse(dateStr);
        }
        catch (ParseException e) {
            retDate = dateParserFormat2.parse(dateStr);
        }
        return retDate;
    }

    private static boolean isBlank(String str) {
        return Strings.nullToEmpty((String)str).trim().isEmpty();
    }
}

