/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.license;

import com.unboundid.common.license.PingLicense;
import com.unboundid.common.messages.UBIDCommonMessages;
import com.unboundid.messages.Message;
import com.unboundid.messages.MessageBuilder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PingLicensePrinter {
    private static DateFormat dateFormat = new SimpleDateFormat("dd/MMM/yyyy");
    private String organization;
    private String product;
    private String version;
    private Date issueDate;
    private Date expirationDate;

    public PingLicensePrinter(PingLicense license) {
        this.organization = license.getOrganization();
        this.product = license.getProduct();
        this.version = license.getVersion();
        this.issueDate = license.getIssueDate();
        if (!license.isPerpetual()) {
            this.expirationDate = license.getExpirationDate();
        }
    }

    public PingLicensePrinter(String organization, String product, String version, Date issueDate, Date expirationDate) {
        this.organization = organization;
        this.product = product;
        this.version = version;
        this.issueDate = issueDate;
        this.expirationDate = expirationDate;
    }

    public Message toMessage() {
        return new MessageBuilder().append((CharSequence)UBIDCommonMessages.INFO_LICENSE_FIELD_ORG.get()).append((CharSequence)" ").append((CharSequence)this.stringValueOrNone(this.organization)).append((CharSequence)"; ").append((CharSequence)UBIDCommonMessages.INFO_LICENSE_FIELD_PRODUCT.get()).append((CharSequence)" ").append((CharSequence)this.stringValueOrNone(this.product)).append((CharSequence)"; ").append((CharSequence)UBIDCommonMessages.INFO_LICENSE_FIELD_VERSION.get()).append((CharSequence)" ").append((CharSequence)this.stringValueOrNone(this.version)).append((CharSequence)"; ").append((CharSequence)UBIDCommonMessages.INFO_LICENSE_FIELD_ISSUE_DATE.get()).append((CharSequence)" ").append((CharSequence)this.dateValueOrNone(this.issueDate)).append((CharSequence)"; ").append((CharSequence)UBIDCommonMessages.INFO_LICENSE_FIELD_EXPIRATION_DATE.get()).append((CharSequence)" ").append((CharSequence)this.dateValueOrNone(this.expirationDate)).toMessage();
    }

    private Message stringValueOrNone(String value) {
        return value != null ? Message.raw((CharSequence)value, (Object[])new Object[0]) : UBIDCommonMessages.INFO_NONE.get();
    }

    private Message dateValueOrNone(Date value) {
        return value != null ? Message.raw((CharSequence)dateFormat.format(value), (Object[])new Object[0]) : UBIDCommonMessages.INFO_NONE.get();
    }
}

