/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.manifest;

import com.unboundid.common.manifest.FileRecord;
import com.unboundid.common.manifest.Manifest;
import com.unboundid.common.util.FileDigest;
import com.unboundid.common.util.FileUtils;
import java.io.File;
import java.io.IOException;

public class ManifestHelper {
    private Manifest manifest;
    private File root;

    public ManifestHelper(Manifest manifest, File root) {
        this.manifest = manifest;
        this.root = root;
    }

    public FileRecord getFileRecord(File file) {
        String relativePath = FileUtils.getRelativePath(file, this.root);
        return this.manifest.getFileRecordForPath(relativePath);
    }

    public boolean isFileInManifest(File f) {
        return this.getFileRecord(f) != null;
    }

    public boolean isFileModified(File f) throws IOException {
        boolean modified = false;
        FileRecord fileRecord = this.getFileRecord(f);
        if (fileRecord != null) {
            FileDigest fd = FileDigest.usingMd5();
            String checkSum = fd.hexStringForFile(f);
            modified = !checkSum.equals(fileRecord.getChecksum());
        }
        return modified;
    }
}

