/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.manifest;

import com.unboundid.common.manifest.FileRecord;
import com.unboundid.common.manifest.Manifest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ManifestParser
extends DefaultHandler {
    private Set<FileRecord> fileRecords;
    private FileRecord currentFileRecord;

    public Manifest read(File manifestFile) throws IOException, SAXException, ParserConfigurationException {
        FileInputStream fis = new FileInputStream(manifestFile);
        return this.read(fis);
    }

    public Manifest read(InputStream manifestStream) throws IOException, SAXException, ParserConfigurationException {
        Manifest manifest = null;
        if (manifestStream != null) {
            manifest = new Manifest();
            this.fileRecords = new HashSet<FileRecord>();
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            spf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            spf.setXIncludeAware(false);
            SAXParser sp = spf.newSAXParser();
            XMLReader reader = sp.getXMLReader();
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            sp.parse(manifestStream, (DefaultHandler)this);
            manifest.setFileRecords(this.fileRecords);
        }
        return manifest;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("file")) {
            this.currentFileRecord = FileRecord.fromAttributes(attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("file")) {
            this.fileRecords.add(this.currentFileRecord);
        }
    }
}

