/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.platform;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ComparableJavaVersion
implements Comparable<ComparableJavaVersion> {
    private int major = 0;
    private int minor = 0;
    private int update = 0;
    private int build = 0;
    private String pre = "";
    private JavaVersionStyle javaVersionStyle = JavaVersionStyle.UNKNOWN;
    public static ComparableJavaVersion currentVersion;

    ComparableJavaVersion(String versionString) {
        Matcher matcher = JavaVersionStyle.CLASSIC.getMatcher(versionString);
        if (matcher.matches()) {
            this.major = this.safeParseInt(matcher.group(2));
            this.minor = this.safeParseInt(matcher.group(3));
            this.update = this.safeParseInt(matcher.group(4));
            this.build = this.safeParseInt(matcher.group(5));
            this.javaVersionStyle = JavaVersionStyle.CLASSIC;
            return;
        }
        matcher = JavaVersionStyle.JDK9.getMatcher(versionString);
        if (matcher.matches()) {
            this.major = this.safeParseInt(matcher.group(1));
            this.minor = this.safeParseInt(matcher.group(2));
            this.update = this.safeParseInt(matcher.group(3));
            this.pre = this.safeParseString(matcher.group(4));
            this.build = this.safeParseInt(matcher.group(5));
            this.javaVersionStyle = JavaVersionStyle.JDK9;
            return;
        }
        this.pre = this.safeParseString(versionString);
    }

    private int safeParseInt(String numberString) {
        if (numberString == null || numberString.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(numberString);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private long safeParseLong(String numberString) {
        if (numberString == null || numberString.isEmpty()) {
            return 0L;
        }
        try {
            return Long.parseLong(numberString);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    private String safeParseString(String string) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        return string;
    }

    public boolean greaterThanOrEqualTo(String versionString) {
        return this.compareTo(new ComparableJavaVersion(versionString)) >= 0;
    }

    public boolean comesBefore(String versionString) {
        return this.compareTo(new ComparableJavaVersion(versionString)) < 0;
    }

    @Override
    public int compareTo(ComparableJavaVersion o) {
        if (this.major < o.major) {
            return -1;
        }
        if (this.major > o.major) {
            return 1;
        }
        if (this.minor < o.minor) {
            return -1;
        }
        if (this.minor > o.minor) {
            return 1;
        }
        if (this.update < o.update) {
            return -1;
        }
        if (this.update > o.update) {
            return 1;
        }
        if (!this.pre.isEmpty() && o.pre.isEmpty()) {
            return -1;
        }
        if (this.pre.isEmpty() && !o.pre.isEmpty()) {
            return 1;
        }
        if (!(this.pre.isEmpty() || o.pre.isEmpty() || this.pre.equals(o.pre))) {
            long thisLong = this.safeParseLong(this.pre);
            long thatLong = this.safeParseLong(o.pre);
            if (thisLong != 0L && thatLong != 0L) {
                if (thisLong < thatLong) {
                    return -1;
                }
                if (thisLong > thatLong) {
                    return 1;
                }
            }
            return this.pre.compareTo(o.pre);
        }
        if (this.build < o.build) {
            return -1;
        }
        if (this.build > o.build) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o instanceof ComparableJavaVersion) {
            return this.compareTo((ComparableJavaVersion)o) == 0;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.javaVersionStyle) {
            case CLASSIC: {
                sb.append("1.");
                sb.append(this.major);
                sb.append(".");
                sb.append(this.minor);
                if (this.update <= 0) break;
                sb.append(" Update ");
                sb.append(this.update);
                break;
            }
            case JDK9: {
                sb.append(this.major);
                sb.append(".");
                sb.append(this.minor);
                sb.append(".");
                sb.append(this.update);
                if (this.pre.isEmpty()) break;
                sb.append(" ");
                sb.append(this.pre);
                break;
            }
            default: {
                sb.append("Unknown Version ");
                sb.append(this.pre);
            }
        }
        if (this.build > 0) {
            sb.append(" Build ");
            sb.append(this.build);
        }
        return sb.toString();
    }

    int getMajorVersion() {
        return this.major;
    }

    int getMinorVersion() {
        return this.minor;
    }

    int getUpdateVersion() {
        return this.update;
    }

    int getBuildVersion() {
        return this.build;
    }

    static {
        ComparableJavaVersion basic = new ComparableJavaVersion(System.getProperty("java.version"));
        ComparableJavaVersion runtime = new ComparableJavaVersion(System.getProperty("java.runtime.version"));
        currentVersion = basic.major == runtime.major && basic.minor == runtime.minor && basic.update == runtime.update && basic.build < runtime.build ? runtime : basic;
    }

    private static enum JavaVersionStyle {
        CLASSIC("^(1)\\.(\\d+)(?:\\.(\\d+))?(?:[_.](\\d+))?(?:.*b(\\d+))?.*"),
        JDK9("^(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?(?:-([a-zA-Z0-9]+))?(?:.*\\+(\\d+))?.*"),
        UNKNOWN(".+");

        private final Pattern pattern;

        private JavaVersionStyle(String patternString) {
            this.pattern = Pattern.compile(patternString);
        }

        Matcher getMatcher(String input) {
            return this.pattern.matcher(input);
        }
    }
}

