/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.platform;

import com.unboundid.common.platform.ComparableJavaVersion;
import java.util.EnumSet;

public enum JavaVersion {
    V_1(1),
    V_2(2),
    V_3(3),
    V_4(4),
    V_5(5),
    V_6(6),
    V_7(7),
    V_8(8),
    V_9(9),
    V_10(10),
    V_11(11),
    V_12(12),
    V_13(13),
    V_14(14),
    V_15(15),
    V_16(16),
    V_17(17),
    V_18(18),
    V_19(19),
    V_20(20);

    private final String name;
    private final Integer majorVersion;

    public static JavaVersion current() {
        return JavaVersion.valueOfString(System.getProperty("java.version"));
    }

    public static JavaVersion valueOfString(String versionString) {
        ComparableJavaVersion cjv = new ComparableJavaVersion(versionString);
        Integer majorVersion = cjv.getMajorVersion();
        for (JavaVersion version : EnumSet.allOf(JavaVersion.class)) {
            if (majorVersion != version.majorVersion) continue;
            return version;
        }
        throw new IllegalArgumentException("Unknown version " + versionString);
    }

    public String getName() {
        return this.name;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    private JavaVersion(Integer majorVersion) {
        this.majorVersion = majorVersion;
        this.name = majorVersion < 9 ? "1." + String.valueOf(majorVersion) : String.valueOf(majorVersion);
    }

    public static boolean comesBefore(JavaVersion javaVersion) {
        return ComparableJavaVersion.currentVersion.comesBefore(javaVersion.getName());
    }

    public static Integer getUpdateVersion() {
        return ComparableJavaVersion.currentVersion.getUpdateVersion();
    }

    public static boolean isIBMJDK() {
        boolean isIBMJDK = false;
        try {
            String javaVendor = System.getProperty("java.vendor");
            isIBMJDK = javaVendor.startsWith("IBM");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isIBMJDK;
    }

    public static boolean isSunJDK() {
        boolean isSunJDK = false;
        try {
            String javaVendor = System.getProperty("java.vendor");
            isSunJDK = javaVendor.toLowerCase().indexOf("sun microsystems") >= 0 || javaVendor.toLowerCase().indexOf("oracle") >= 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isSunJDK;
    }

    public static boolean isJDK15() {
        return JavaVersion.isJDKX(5);
    }

    public static boolean isJDK7() {
        return JavaVersion.isJDKX(7);
    }

    public static boolean isJDK8() {
        return JavaVersion.isJDKX(8);
    }

    public static boolean isJDK9() {
        return JavaVersion.isJDKX(9);
    }

    public static boolean isJDKX(int majorVersion) {
        return ComparableJavaVersion.currentVersion.getMajorVersion() == majorVersion;
    }
}

