/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.types;

import com.unboundid.common.messages.UBIDCommonMessages;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.extensions.StartTLSExtendedRequest;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ssl.SSLUtil;
import java.security.GeneralSecurityException;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class LDAPServerAddress {
    private LDAPURL ldapURL;
    private boolean supportsStartTLS;

    public LDAPServerAddress(String host, int port, boolean isSSL) throws LDAPException {
        this(host + ":" + Integer.toString(port), isSSL);
    }

    public LDAPServerAddress(String hostPort) throws LDAPException {
        int colonPos = hostPort.indexOf("://");
        String urlString = colonPos < 0 ? "ldap://" + hostPort : hostPort;
        this.ldapURL = this.createURL(urlString);
    }

    public LDAPServerAddress(String hostPort, boolean isSSL) throws LDAPException {
        this(hostPort, isSSL, false);
    }

    public LDAPServerAddress(String hostPort, boolean isSSL, boolean supportsStartTLS) throws LDAPException {
        int colonPos = hostPort.indexOf("://");
        String urlString = colonPos < 0 ? (isSSL ? "ldaps://" + hostPort : "ldap://" + hostPort) : hostPort;
        this.ldapURL = this.createURL(urlString);
        this.supportsStartTLS = supportsStartTLS;
    }

    public String getHost() {
        return this.ldapURL.getHost();
    }

    public int getPort() {
        return this.ldapURL.getPort();
    }

    public void setSupportsStartTls(boolean supportsStartTls) {
        this.supportsStartTLS = supportsStartTls;
    }

    public boolean supportsStartTLS() {
        return this.supportsStartTLS;
    }

    public boolean isSSL() {
        return "ldaps".equals(this.ldapURL.getScheme());
    }

    public void toURLString(StringBuilder buffer) {
        buffer.append(this.ldapURL.getScheme());
        buffer.append("://");
        String host = this.ldapURL.getHost();
        if (host != null) {
            if (host.indexOf(58) >= 0) {
                buffer.append('[');
                buffer.append(StaticUtils.toLowerCase((String)host));
                buffer.append(']');
            } else {
                buffer.append(StaticUtils.toLowerCase((String)host));
            }
        }
        if (!this.ldapURL.getScheme().equals("ldapi")) {
            buffer.append(':');
            buffer.append(this.ldapURL.getPort());
        }
    }

    public void toHostPortString(StringBuilder buffer) {
        String host = this.ldapURL.getHost();
        if (host != null) {
            if (host.indexOf(58) >= 0) {
                buffer.append('[');
                buffer.append(StaticUtils.toLowerCase((String)host));
                buffer.append(']');
            } else {
                buffer.append(StaticUtils.toLowerCase((String)host));
            }
        }
        if (!this.ldapURL.getScheme().equals("ldapi")) {
            buffer.append(':');
            buffer.append(this.ldapURL.getPort());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toHostPortString(sb);
        return sb.toString();
    }

    public String toURLString() {
        StringBuilder sb = new StringBuilder();
        this.toURLString(sb);
        return sb.toString();
    }

    public String toHostPortString() {
        StringBuilder buffer = new StringBuilder();
        this.toHostPortString(buffer);
        return buffer.toString();
    }

    public LDAPConnection createConnection(String bindDn, char[] password, boolean useStartTls, KeyManager keyManager, TrustManager trustManager, LDAPConnectionOptions options) throws LDAPException {
        LDAPConnection connection;
        SSLUtil sslUtil = null;
        if (this.isSSL() || useStartTls) {
            sslUtil = new SSLUtil(keyManager, trustManager);
        }
        if (this.isSSL()) {
            try {
                assert (sslUtil != null);
                connection = new LDAPConnection((SocketFactory)sslUtil.createSSLSocketFactory(), options, this.getHost(), this.getPort(), bindDn, password != null ? new String(password) : null);
            }
            catch (GeneralSecurityException e) {
                throw new LDAPException(ResultCode.LOCAL_ERROR, UBIDCommonMessages.ERR_LDAP_TOOL_CANNOT_CREATE_SSL_SOCKET_FACTORY.get((Object)StaticUtils.getStackTrace((Throwable)e)).toString());
            }
        }
        connection = new LDAPConnection(options, this.getHost(), this.getPort());
        if (useStartTls) {
            SSLContext sslContext;
            try {
                sslContext = sslUtil.createSSLContext();
            }
            catch (Exception e) {
                throw new LDAPException(ResultCode.LOCAL_ERROR, UBIDCommonMessages.ERR_LDAP_TOOL_CANNOT_CREATE_SSL_CONTEXT.get((Object)StaticUtils.getStackTrace((Throwable)e)).toString(), (Throwable)e);
            }
            ExtendedResult extendedResult = connection.processExtendedOperation((ExtendedRequest)new StartTLSExtendedRequest(sslContext));
            if (!extendedResult.getResultCode().equals((Object)ResultCode.SUCCESS)) {
                throw new LDAPException(extendedResult.getResultCode(), UBIDCommonMessages.ERR_LDAP_TOOL_START_TLS_FAILED.get((Object)extendedResult.getDiagnosticMessage()).toString());
            }
        }
        connection.bind(bindDn, password != null ? new String(password) : null);
        return connection;
    }

    private LDAPURL createURL(String urlString) throws LDAPException {
        LDAPURL url = new LDAPURL(urlString);
        if (url.getHost() == null) {
            throw new LDAPException(ResultCode.LOCAL_ERROR, UBIDCommonMessages.ERR_LDAP_SERVER_ADDR_HOST_UNSPECIFIED.get((Object)urlString).toString());
        }
        return url;
    }
}

