/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.types;

import com.unboundid.common.messages.UBIDCommonMessages;
import com.unboundid.common.types.SyntaxException;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Rate
implements Serializable {
    static final long serialVersionUID = 42L;
    private static final Map<String, Long> COUNT_MULTIPLIERS;
    private static final Map<String, Long> DURATION_UNITS;
    private final long maxCount;
    private final long intervalDuration;
    private final String stringRepresentation;

    public static Rate decode(String value) throws SyntaxException {
        return new Rate(value);
    }

    public Rate(long maxCount, long intervalDuration) {
        Validator.ensureTrue((maxCount >= 1L ? 1 : 0) != 0);
        Validator.ensureTrue((intervalDuration >= 1L ? 1 : 0) != 0);
        this.maxCount = maxCount;
        this.intervalDuration = intervalDuration;
        this.stringRepresentation = maxCount + "/" + intervalDuration + "ms";
    }

    public Rate(String s) throws SyntaxException {
        Validator.ensureNotNull((Object)s);
        this.stringRepresentation = s;
        int slashPos = s.indexOf(47);
        if (slashPos < 0) {
            throw new SyntaxException(UBIDCommonMessages.ERR_RATE_MONITOR_NO_SLASH.get((Object)s));
        }
        if (slashPos == 0) {
            throw new SyntaxException(UBIDCommonMessages.ERR_RATE_MONITOR_NO_COUNT.get((Object)s));
        }
        if (slashPos == s.length() - 1) {
            throw new SyntaxException(UBIDCommonMessages.ERR_RATE_MONITOR_NO_DURATION.get((Object)s));
        }
        String countStr = s.substring(0, slashPos).trim();
        ObjectPair<Long, Long> countPair = Rate.parseStringWithUnit(countStr, COUNT_MULTIPLIERS);
        if (countPair.getFirst() == null) {
            throw new SyntaxException(UBIDCommonMessages.ERR_RATE_MONITOR_COUNT_WITHOUT_INTEGER.get((Object)s));
        }
        this.maxCount = countPair.getSecond() == null ? (Long)countPair.getFirst() : (Long)countPair.getFirst() * (Long)countPair.getSecond();
        if (this.maxCount <= 0L) {
            throw new SyntaxException(UBIDCommonMessages.ERR_RATE_MONITOR_COUNT_NOT_GT_ZERO.get((Object)s));
        }
        String durationStr = s.substring(slashPos + 1).trim();
        ObjectPair<Long, Long> durationPair = Rate.parseStringWithUnit(durationStr, DURATION_UNITS);
        if (durationPair.getSecond() == null) {
            throw new SyntaxException(UBIDCommonMessages.ERR_RATE_MONITOR_DURATION_WITHOUT_UNIT.get((Object)s));
        }
        this.intervalDuration = durationPair.getFirst() == null ? (Long)durationPair.getSecond() : (Long)durationPair.getFirst() * (Long)durationPair.getSecond();
        if (this.intervalDuration <= 0L) {
            throw new SyntaxException(UBIDCommonMessages.ERR_RATE_MONITOR_DURATION_NOT_GT_ZERO.get((Object)s));
        }
    }

    public Rate(long maxCount, long intervalDuration, String monitorString) {
        this.maxCount = maxCount;
        this.intervalDuration = intervalDuration;
        this.stringRepresentation = monitorString;
    }

    private static ObjectPair<Long, Long> parseStringWithUnit(String s, Map<String, Long> m) throws SyntaxException {
        boolean nonDigitFound = false;
        int nonDigitPos = -1;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') continue;
            nonDigitFound = true;
            nonDigitPos = i;
            break;
        }
        if (nonDigitFound) {
            if (nonDigitPos == 0) {
                String multiplierStr = StaticUtils.toLowerCase((String)s.substring(nonDigitPos).trim());
                Long multiplierValue = m.get(multiplierStr);
                if (multiplierValue == null) {
                    throw new SyntaxException(UBIDCommonMessages.ERR_RATE_MONITOR_INVALID_STRING_COMPONENT.get((Object)s, (Object)multiplierStr));
                }
                return new ObjectPair(null, (Object)multiplierValue);
            }
            String multiplierStr = StaticUtils.toLowerCase((String)s.substring(nonDigitPos).trim());
            Long multiplierValue = m.get(multiplierStr);
            if (multiplierValue == null) {
                throw new SyntaxException(UBIDCommonMessages.ERR_RATE_MONITOR_INVALID_STRING_COMPONENT.get((Object)s, (Object)multiplierStr));
            }
            return new ObjectPair((Object)Long.parseLong(s.substring(0, nonDigitPos)), (Object)multiplierValue);
        }
        return new ObjectPair((Object)Long.parseLong(s), null);
    }

    public long getMaxCount() {
        return this.maxCount;
    }

    public long getIntervalDuration() {
        return this.intervalDuration;
    }

    public Rate duplicate() {
        return new Rate(this.maxCount, this.intervalDuration, this.stringRepresentation);
    }

    public String toString() {
        return this.stringRepresentation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rate rate = (Rate)o;
        if (this.intervalDuration != rate.intervalDuration) {
            return false;
        }
        return this.maxCount == rate.maxCount;
    }

    public int hashCode() {
        int result = (int)(this.maxCount ^ this.maxCount >>> 32);
        result = 31 * result + (int)(this.intervalDuration ^ this.intervalDuration >>> 32);
        return result;
    }

    static {
        HashMap<String, Long> m = new HashMap<String, Long>(3);
        m.put("k", 1000L);
        m.put("m", 1000000L);
        m.put("g", 1000000000L);
        COUNT_MULTIPLIERS = Collections.unmodifiableMap(m);
        m = new HashMap(26);
        m.put("ms", 1L);
        m.put("millisecond", 1L);
        m.put("milliseconds", 1L);
        m.put("s", 1000L);
        m.put("sec", 1000L);
        m.put("secs", 1000L);
        m.put("second", 1000L);
        m.put("seconds", 1000L);
        m.put("m", 60000L);
        m.put("min", 60000L);
        m.put("mins", 60000L);
        m.put("minute", 60000L);
        m.put("minutes", 60000L);
        m.put("h", 3600000L);
        m.put("hr", 3600000L);
        m.put("hrs", 3600000L);
        m.put("hour", 3600000L);
        m.put("hours", 3600000L);
        m.put("d", 86400000L);
        m.put("day", 86400000L);
        m.put("days", 86400000L);
        m.put("w", 604800000L);
        m.put("wk", 604800000L);
        m.put("wks", 604800000L);
        m.put("week", 604800000L);
        m.put("weeks", 604800000L);
        DURATION_UNITS = Collections.unmodifiableMap(m);
    }
}

