/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.types;

import com.unboundid.messages.Message;

public abstract class UnboundIDException
extends Exception {
    private static final boolean VERBOSE_MESSAGES;
    Message message;

    protected UnboundIDException() {
    }

    protected UnboundIDException(UnboundIDException cause) {
        this((Message)null, (Throwable)cause);
    }

    protected UnboundIDException(Message message) {
        this(message, null);
    }

    protected UnboundIDException(Throwable cause) {
        this((Message)null, cause);
    }

    protected UnboundIDException(Message message, Throwable cause) {
        super(message != null ? message.toString() : (cause != null ? cause.getMessage() : null), cause);
        if (message != null) {
            this.message = message;
        } else if (cause instanceof UnboundIDException) {
            this.message = ((UnboundIDException)cause).getMessageObject();
        }
    }

    public Message getMessageObject() {
        if (VERBOSE_MESSAGES) {
            StringBuilder msg = new StringBuilder();
            UnboundIDException.stackTraceToSingleLineString(msg, this, Integer.MAX_VALUE);
            return Message.raw((CharSequence)msg.toString(), (Object[])new Object[0]);
        }
        return this.message;
    }

    protected void setMessageObject(Message message) {
        this.message = message;
    }

    public static String stackTraceToSingleLineString(Throwable t) {
        StringBuilder buffer = new StringBuilder();
        UnboundIDException.stackTraceToSingleLineString(buffer, t, Integer.MAX_VALUE);
        return buffer.toString();
    }

    public static void stackTraceToSingleLineString(StringBuilder buffer, Throwable t, int maxFrames) {
        if (t == null) {
            return;
        }
        String message = t.getMessage();
        if (message == null || message.length() == 0) {
            String className = t.getClass().getName();
            try {
                className = className.substring(className.lastIndexOf(46) + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            buffer.append(className);
        } else {
            buffer.append(message);
        }
        buffer.append(" (");
        buffer.append(UnboundIDException.stackTraceElementsToString(t.getStackTrace(), maxFrames));
        for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
            buffer.append(" caused by ");
            message = cause.getMessage();
            if (message == null || message.length() == 0) {
                String className = cause.getClass().getName();
                try {
                    className = className.substring(className.lastIndexOf(46) + 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                buffer.append(className);
            } else {
                buffer.append(message);
            }
            buffer.append(UnboundIDException.stackTraceElementsToString(cause.getStackTrace(), maxFrames));
        }
        buffer.append(')');
    }

    public static String stackTraceElementsToString(StackTraceElement[] elements, int maxFrames) {
        if (elements != null && elements.length > 0) {
            StringBuilder buffer = new StringBuilder();
            int tracesToAppend = maxFrames <= 0 ? elements.length : Math.min(maxFrames, elements.length);
            for (int i = 0; i < tracesToAppend; ++i) {
                StackTraceElement e = elements[i];
                buffer.append(e.getFileName()).append(':').append(e.getLineNumber());
                if (i >= elements.length - 1) continue;
                buffer.append(' ');
            }
            if (tracesToAppend < elements.length) {
                buffer.append("...");
            }
            return buffer.toString();
        }
        return "";
    }

    static {
        String envVerbose = System.getenv("UBID_VERBOSE_EX_MSGS");
        String propVerbose = System.getProperty("com.unboundid.directory.server.VerboseExceptionMessages");
        VERBOSE_MESSAGES = "true".equals(envVerbose) || "true".equals(propVerbose);
    }
}

