/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.update;

import com.unboundid.common.util.FileUtils;
import com.unboundid.common.util.tools.ToolConstants;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileActionLogger {
    public static final String REPLACED = "replaced";
    public static final String DELETED = "deleted";
    public static final String ADDED = "added";
    public static final String FILE = "file";
    public static final String NO_ACTIONS = "# No file actions";
    public static final String DIRECTORY = "directory";
    private static final Logger LOG = Logger.getLogger(FileActionLogger.class.getName());
    private FileWriter writer;
    private File serverRoot;
    private boolean actionsLogged;

    public FileActionLogger(File file, File serverRoot) throws IOException {
        this.writer = new FileWriter(file);
        this.serverRoot = serverRoot;
    }

    public void logReplace(File target) {
        this.log(REPLACED + " " + (target.isDirectory() ? DIRECTORY : FILE) + " " + FileUtils.getRelativePath(target, this.serverRoot));
    }

    public void logDelete(File target, boolean isDirectory) {
        this.log(DELETED + " " + (isDirectory ? DIRECTORY : FILE) + " " + FileUtils.getRelativePath(target, this.serverRoot));
    }

    public void logAdd(File target) {
        this.log(ADDED + " " + (target.isDirectory() ? DIRECTORY : FILE) + " " + FileUtils.getRelativePath(target, this.serverRoot));
    }

    private void log(String msg) {
        try {
            this.writer.write(msg);
            this.writer.write(ToolConstants.EOL);
            this.actionsLogged = true;
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Failed log add action '" + msg + "'");
        }
    }

    public void close() {
        if (!this.actionsLogged) {
            try {
                this.writer.write(NO_ACTIONS);
                this.writer.write(ToolConstants.EOL);
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, "Error writing 'no action' comment");
            }
        }
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

